package main.service;

import java.util.Random;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

import main.repository.SupportTicketService;

@Service
@Qualifier("supportTicketService")
public class SupportTicketServiceImpl implements SupportTicketService {
	private static final Logger log = LoggerFactory.getLogger(SupportTicketServiceImpl.class);

	private static final String OPENED_TICKET_MESSAGE = "Se ha enviado el Ticket #%d  a soporte.";
	private final Random rand = new Random();

	/**
	 * Maneja la apertura de un nuevo ticket, le asigna un número al ticket y lo añade al log junto con la información recibida
	 *
	 * @param ticketIssue
	 * 		asunto del ticket
	 *
	 * @return Un mensaje con el número al que se le ha asignado al ticket
	 */
	@Override
	public String handleTicketOpening(String ticketIssue) {
		final int ticketNumber = rand.nextInt(10000);
		log.info("Nuevo Ticket abierto: #{}. Asunto:{}", ticketNumber, ticketIssue);
		return String.format(OPENED_TICKET_MESSAGE, ticketNumber);

	}

}
