package main.model;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;

import org.hibernate.annotations.UuidGenerator;

import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;

@Entity
@Table(name = "incidence")
public class IncidenceModel {

	@Id
	@UuidGenerator
	private String id;
	private String incidenceNumber;
	private String dni;
	private String subject;
	private String gestionaRegistryNumber;
	private String gestionaFileNumber;
	private Integer priority;
	private IncidentStatus status;

	public IncidenceModel() {

	}

	public IncidenceModel(String id, String incidenceNumber, String dni, String subject, String registryNumber, String fileNumber, int priority,
			IncidentStatus incidentStatus) {
		this.id = id;
		this.incidenceNumber = incidenceNumber;
		this.dni = dni;
		this.subject = subject;
		this.gestionaRegistryNumber = registryNumber;
		this.gestionaFileNumber = fileNumber;
		this.priority = priority;
		this.status = incidentStatus;
	}

	public IncidenceModel(String dni, String subject, String registryNumber, String fileNumber, IncidentStatus incidentStatus) {
		this.incidenceNumber = generateTimestamp();
		this.dni = dni;
		this.subject = subject;
		this.gestionaRegistryNumber = registryNumber;
		this.gestionaFileNumber = fileNumber;
		this.status = incidentStatus;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getIncidenceNumber() {
		return incidenceNumber;
	}

	public void setIncidenceNumber(String incidenceNumber) {
		this.incidenceNumber = incidenceNumber;
	}

	public String getDni() {
		return dni;
	}

	public void setDni(String dni) {
		this.dni = dni;
	}

	public String getSubject() {
		return subject;
	}

	public void setSubject(String subject) {
		this.subject = subject;
	}

	public String getGestionaRegistryNumber() {
		return gestionaRegistryNumber;
	}

	public void setGestionaRegistryNumber(String gestionaRegistryNumber) {
		this.gestionaRegistryNumber = gestionaRegistryNumber;
	}

	public String getGestionaFileNumber() {
		return gestionaFileNumber;
	}

	public void setGestionaFileNumber(String gestionaFileNumber) {
		this.gestionaFileNumber = gestionaFileNumber;
	}

	public IncidentStatus getStatus() {
		return status;
	}

	public void setStatus(IncidentStatus status) {
		this.status = status;
	}

	private String generateTimestamp() {
		return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
	}

	public Integer getPriority() {
		return priority;
	}

	public void setPriority(int priority) {
		this.priority = priority;
	}

	public enum IncidentStatus {
		RESOLVED,       // Resuelta
		ASSIGNED,       // Asignada
		UNASSIGNED;     // Sin asignar

		@Override
		public String toString() {
			switch (this) {
				case RESOLVED -> {
					return "Resuelta";
				}
				case ASSIGNED -> {
					return "Asignada";
				}
				case UNASSIGNED -> {
					return "Sin asignar";
				}
			}
			return "";
		}
	}
}
