package main.model;

import java.util.List;

import org.hibernate.annotations.UuidGenerator;

import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import jakarta.persistence.Transient;
import main.gestiona.apirest.model.CircuitTemplateModel;

@Entity
@Table(name = "documentary_flow")
public class DocumentaryFlowModel {

	@Id
	@UuidGenerator
	private String id;
	private String fileCodeGestiona;
	private String fileIdGestiona;
	private String documentCsv;
	private String registryIdGestiona;
	private String registryCodeGestiona;
	private String dni;
	private Status state;
	// TODO: el estado de notificación tendrá que ser un enum cuando sepamos sus valores
	private String notificationState;
	private String documentReference;

	@Transient
	private List<CircuitTemplateModel> circuitTemplates;

	public DocumentaryFlowModel() {

	}

	public DocumentaryFlowModel(String fileCodeGestiona, String fileIdGestiona) {
		this.fileCodeGestiona = fileCodeGestiona;
		this.fileIdGestiona = fileIdGestiona;
		this.state = Status.PENDING;
	}

	public DocumentaryFlowModel(String id, String fileCodeGestiona, String fileIdGestiona, String documentCsv, String registryIdGestiona,
			String registryCodeGestiona, String dni, String state, String notificationState) {
		this.id = id;
		this.fileCodeGestiona = fileCodeGestiona;
		this.fileIdGestiona = fileIdGestiona;
		this.documentCsv = documentCsv;
		this.registryIdGestiona = registryIdGestiona;
		this.registryCodeGestiona = registryCodeGestiona;
		this.dni = dni;
		this.state = Status.valueOf(state);
		this.notificationState = notificationState;
	}

	public String getFileIdGestiona() {
		return fileIdGestiona;
	}

	public void setFileIdGestiona(String fileIdGestiona) {
		this.fileIdGestiona = fileIdGestiona;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getFileCodeGestiona() {
		return fileCodeGestiona;
	}

	public void setFileCodeGestiona(String fileCodeGestiona) {
		this.fileCodeGestiona = fileCodeGestiona;
	}

	public String getDocumentCsv() {
		return documentCsv;
	}

	public void setDocumentCsv(String documentCsv) {
		this.documentCsv = documentCsv;
	}

	public String getRegistryIdGestiona() {
		return registryIdGestiona;
	}

	public void setRegistryIdGestiona(String registryIdGestiona) {
		this.registryIdGestiona = registryIdGestiona;
	}

	public String getRegistryCodeGestiona() {
		return registryCodeGestiona;
	}

	public void setRegistryCodeGestiona(String registryCodeGestiona) {
		this.registryCodeGestiona = registryCodeGestiona;
	}

	public String getDni() {
		return dni;
	}

	public void setDni(String dni) {
		this.dni = dni;
	}

	public Status getState() {
		return state;
	}

	public void setState(Status state) {
		this.state = state;
	}

	public String getNotificationState() {
		return notificationState;
	}

	public void setNotificationState(String notificationState) {
		this.notificationState = notificationState;
	}

	public String getDocumentReference() {
		return documentReference;
	}

	public void setDocumentReference(String documentReference) {
		this.documentReference = documentReference;
	}

	public List<CircuitTemplateModel> getCircuitTemplates() {
		return circuitTemplates;
	}

	public void setCircuitTemplates(List<CircuitTemplateModel> circuitTemplates) {
		this.circuitTemplates = circuitTemplates;
	}

	public enum Status {
		PENDING,       // Pendiente
		UPLOADED,        // Subido
		IN_PROCESS,    // En tramitación
		CANCELED,        // Cancelado
		REVOKED,        // Rechazado
		FAILED,            // Fallido
		FINISHED,        // Terminado
		UNKNOWN_ERROR,        // Error desconocido
		FINISHED_WITH_ERRORS; // Terminado con errores

		@Override
		public String toString() {
			switch (this) {
				case PENDING -> {
					return "Pendiente";
				}
				case UPLOADED -> {
					return "Subido";
				}
				case IN_PROCESS -> {
					return "En tramitación";
				}
				case FINISHED -> {
					return "Tramitado";
				}
				case CANCELED -> {
					return "Cancelado";
				}
				case REVOKED -> {
					return "Rechazado";
				}
				case FAILED -> {
					return "Fallido";
				}
				case UNKNOWN_ERROR -> {
					return "Error desconocido";
				}
				case FINISHED_WITH_ERRORS -> {
					return "Terminado con errores";
				}
			}
			return "";
		}
	}
}
