package main.loader;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Component;

import main.model.DocumentaryFlowModel;
import main.model.IncidenceModel;
import main.model.IncidenceModel.IncidentStatus;
import main.repository.DocumentaryFlowRepository;
import main.repository.IncidenceRepository;
import main.service.DatabaseService;

@Component
public class DataLoader implements CommandLineRunner {

	private static final Logger log = LoggerFactory.getLogger(DataLoader.class);

	private final DocumentaryFlowRepository documentaryFlowRepository;
	private final IncidenceRepository incidenceRepository;

	@Autowired
	private DatabaseService databaseService;

	public DataLoader(DocumentaryFlowRepository repository, IncidenceRepository incidenceRepository) {
		this.documentaryFlowRepository = repository;
		this.incidenceRepository = incidenceRepository;
	}

	@Override
	public void run(String... args) {
		if (databaseService.getPopulate()) {
			log.info("Loading data...");
			loadDocumentaryFlowInitialData();
			loadIncidenceInitialData();
			log.info("Data loaded successfully.");
		} else {
			log.info("Data loading is disabled.");
		}
	}

	private void loadDocumentaryFlowInitialData() {

		// Carga de datos de los flujos documentales
		documentaryFlowRepository.save(
				new DocumentaryFlowModel("id1", "expCode1", "expId1", "docCSV1", "regId1", "regCode1", "12345678A", "PENDING", "Pendiente"));
		documentaryFlowRepository.save(
				new DocumentaryFlowModel("id2", "expCode2", "expId2", "docCSV2", "regId2", "regCode2", "12345678A", "IN_PROCESS", "Pendiente"));
		documentaryFlowRepository.save(
				new DocumentaryFlowModel("id3", "expCode3", "expId3", "docCSV3", "regId3", "regCode3", "12345678A", "FINISHED", "Terminado"));
		documentaryFlowRepository.save(
				new DocumentaryFlowModel("id4", "expCode4", "expId4", "docCSV4", "regId4", "regCode4", "12345678A", "PENDING", "Pendiente"));
		documentaryFlowRepository.save(
				new DocumentaryFlowModel("id5", "expCode5", "expId5", "docCSV5", "regId5", "regCode5", "12345678A", "PENDING", "Pendiente"));

	}

	private void loadIncidenceInitialData() {

		// Carga de datos de las incidencias
		incidenceRepository.save(new IncidenceModel("1", "INC-001", "12345678A", "Issue with the network", "REG-001", "EXP-001", 5, IncidentStatus.UNASSIGNED));
		incidenceRepository.save(new IncidenceModel("2", "INC-002", "87654321B", "Server downtime", "REG-002", "EXP-002", 2, IncidentStatus.ASSIGNED));
		incidenceRepository.save(
				new IncidenceModel("3", "INC-003", "13579246C", "Error in database connection", "REG-003", "EXP-003", 3, IncidentStatus.RESOLVED));
		incidenceRepository.save(
				new IncidenceModel("4", "INC-004", "24681357D", "Email service not working", "REG-004", "EXP-004", 9, IncidentStatus.ASSIGNED));
		incidenceRepository.save(new IncidenceModel("5", "INC-005", "11223344E", "Security breach detected", "REG-005", "EXP-005", 2, IncidentStatus.RESOLVED));
		incidenceRepository.save(
				new IncidenceModel("6", "INC-006", "99887766F", "Software installation issue", "REG-006", "EXP-006", 1, IncidentStatus.UNASSIGNED));
	}
}