package main.gestiona.apirest.service;

import static main.gestiona.apirest.GestionaAPIResources.obtainLinkByRel;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;

import main.exception.GestionaAPIException;
import main.gestiona.apirest.GestionaAPIResources;
import main.gestiona.apirest.model.FileModel;
import main.gestiona.apirest.model.FileOpeningModel;
import main.gestiona.apirest.model.FilePageModel;

@Service
public class FileService {

	public static final String MEDIA_TYPE_FILE_OPENING = "application/vnd.gestiona.file-opening+json; version=1";
	private static final String GESTIONA_FILES_REL = "vnd.gestiona.files";
	private static final String FILE_OPEN_REL = "file-open";
	@Autowired
	private GestionaAPIResources gestionaAPIResources;

	/**
	 * Extrae de la API de Gestiona los expedientes asociados al usuario del access token. Extrae únicamente la primera página de resultados.
	 *
	 * @return el listado de expedientes mapeados a la clase FileModel.
	 *
	 * @throws GestionaAPIException
	 * 		en caso de error en la llamada a la API de Gestiona
	 */
	public List<FileModel> getFileList() throws GestionaAPIException {

		try {
			// Obtenemos la url del recurso "files"
			final String url = gestionaAPIResources.getBookmarkUrl(GESTIONA_FILES_REL);

			return Objects.requireNonNull(gestionaAPIResources.createPetition(url, HttpMethod.GET, null, null, FilePageModel.class).getBody()).getContent();

		} catch (RestClientException e) {
			throw new GestionaAPIException("Error obteniendo el listado de expedientes: " + e.getMessage());
		}
	}

	/**
	 * Abre un expediente con los datos del `fileOpeningModel`
	 *
	 * @param fileOpeningModel
	 * 		modelo del fileOpening con los datos del expediente a abrir
	 *
	 * @return el modelo del expediente abierto
	 *
	 * @throws GestionaAPIException
	 * 		en caso de error en la llamada a la API de Gestiona
	 */
	public FileModel openFile(FileOpeningModel fileOpeningModel) throws GestionaAPIException {
		try {
			final String url = obtainLinkByRel(fileOpeningModel.getLinks(), FILE_OPEN_REL);

			final Map<String, String> extraHeaders = new HashMap<>();
			extraHeaders.put(GestionaAPIResources.CONTENT_TYPE, MEDIA_TYPE_FILE_OPENING);

			return Objects.requireNonNull(gestionaAPIResources.createPetition(url, HttpMethod.POST, extraHeaders, fileOpeningModel, FileModel.class).getBody());

		} catch (RestClientException e) {
			throw new GestionaAPIException("Error obteniendo el listado de expedientes: " + e.getMessage());
		}
	}
}
