package main.gestiona.apirest.service;

import java.util.List;
import java.util.Objects;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestClientException;

import main.exception.GestionaAPIException;
import main.gestiona.apirest.GestionaAPIResources;
import main.gestiona.apirest.model.CircuitTemplateModel;
import main.gestiona.apirest.model.CircuitTemplatePageModel;

@Service
public class CircuitService {

	@Autowired
	private GestionaAPIResources gestionaAPIResources;


	/**
	 * Obtiene el listado de circuitos de tramitación asociados a un documento a través de su URL
	 *
	 * @param circuitsTemplatesURL
	 * 		la URL al recurso donde se encuentran los circuitos de tramitación
	 *
	 * @return el listado de circuitos de tramitación asociados al documento
	 *
	 * @throws GestionaAPIException
	 * 		si no se ha podido obtener los circuitos de tramitación asociados al documento
	 */
	public List<CircuitTemplateModel> obtainCircuitsTemplates(String circuitsTemplatesURL) throws GestionaAPIException {
		try {

			return Objects.requireNonNull(
							gestionaAPIResources.createPetition(circuitsTemplatesURL, HttpMethod.GET, null, null, CircuitTemplatePageModel.class).getBody())
					.getContent();

		} catch (RestClientException e) {
			throw new GestionaAPIException("No se ha podido obtener los circuitos de tramitación del documento: " + e.getMessage());
		}
	}

}
