package main.gestiona.apirest.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import main.gestiona.apirest.GestionaAPIResources.NotificationChannel;
import main.gestiona.apirest.GestionaAPIResources.RelationType;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ThirdPartyModel {
	private static final Logger log = LoggerFactory.getLogger(ThirdPartyModel.class);

	private String id;
	private String name;
	private String first_name;
	private String first_surname;
	private String second_surname;
	private String nif;
	private NotificationChannel notification_channel;
	private RelationType relation;
	private String type;
	private String version;

	private List<LinkModel> links;

	public ThirdPartyModel() {
        links = new ArrayList<>();
    }

	public ThirdPartyModel(ThirdModel thirdModel) {
		this.first_name = thirdModel.getFirst_name();
		this.first_surname = thirdModel.getFirst_surname();
		this.nif = thirdModel.getNif();
		this.notification_channel = thirdModel.getNotification_channel();
		this.relation = RelationType.INVOLVED;
		this.type = thirdModel.getType();
	}

	@Override
	public String toString() {
		final ObjectMapper objectMapper = new ObjectMapper();
		try {
			// Convertir el objeto a JSON
			return objectMapper.writeValueAsString(this);
		} catch (JsonProcessingException e) {
			log.error("Ha ocurrido un error al convertir el circuito de tramitación a JSON: {}", e.getMessage());
			return "{}"; // Si hay un error, devolver un JSON vacío
		}
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getFirst_name() {
		return first_name;
	}

	public void setFirst_name(String first_name) {
		this.first_name = first_name;
	}

	public String getFirst_surname() {
		return first_surname;
	}

	public void setFirst_surname(String first_surname) {
		this.first_surname = first_surname;
	}

	public String getSecond_surname() {
		return second_surname;
	}

	public void setSecond_surname(String second_surname) {
		this.second_surname = second_surname;
	}

	public String getNif() {
		return nif;
	}

	public void setNif(String nif) {
		this.nif = nif;
	}

	public NotificationChannel getNotification_channel() {
		return notification_channel;
	}

	public void setNotification_channel(NotificationChannel notification_channel) {
		this.notification_channel = notification_channel;
	}

	public RelationType getRelation() {
		return relation;
	}

	public void setRelation(RelationType relation) {
		this.relation = relation;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public List<LinkModel> getLinks() {
		return links;
	}

	public void setLinks(List<LinkModel> links) {
		this.links = links;
	}

	public void addLink(LinkModel linkModel) {
		if (Objects.isNull(links)) {
			links = new ArrayList<>();
		}
		this.links.add(linkModel);
	}

}
