package main.gestiona.apirest.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import main.gestiona.apirest.GestionaAPIResources.NotificationChannel;
import main.gestiona.apirest.GestionaAPIResources.RelationType;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ThirdOutputModel {
	private static final Logger log = LoggerFactory.getLogger(ThirdOutputModel.class);
	private NotificationChannel notification_channel;
	private String email;
	private RelationType relation;
	private boolean allowed_access;
	private String type_of_road;
	private String address;
	private String number;
	private String block;
	private String stair;
	private String floor;
	private String door;
	private String extension;
	private String country;
	private String zip;
	private String zone;
	private String disseminated_nucleus;
	private String province;
	private String delivery_point;
	private String geographical_point;
	private List<LinkModel> links;

	@Override
	public String toString() {
		final ObjectMapper objectMapper = new ObjectMapper();
		try {
			// Convertir el objeto a JSON
			return objectMapper.writeValueAsString(this);
		} catch (JsonProcessingException e) {
			log.error("Ha ocurrido un error al convertir el circuito de tramitación a JSON: {}", e.getMessage());
			return "{}"; // Si hay un error, devolver un JSON vacío
		}
	}

	public NotificationChannel getNotification_channel() {
		return notification_channel;
	}

	public void setNotification_channel(String notification_channel) {
		this.notification_channel = NotificationChannel.valueOf(notification_channel);
	}

	public void setNotification_channel(NotificationChannel notification_channel) {
		this.notification_channel = notification_channel;
	}

	public String getEmail() {
		return email;
	}

	public void setEmail(String email) {
		this.email = email;
	}

	public RelationType getRelation() {
		return relation;
	}

	public void setRelation(String relation) {
		this.relation = RelationType.valueOf(relation);
	}

	public void setRelation(RelationType relation) {
		this.relation = relation;
	}

	public boolean isAllowed_access() {
		return allowed_access;
	}

	public void setAllowed_access(boolean allowed_access) {
		this.allowed_access = allowed_access;
	}

	public String getType_of_road() {
		return type_of_road;
	}

	public void setType_of_road(String type_of_road) {
		this.type_of_road = type_of_road;
	}

	public String getAddress() {
		return address;
	}

	public void setAddress(String address) {
		this.address = address;
	}

	public String getNumber() {
		return number;
	}

	public void setNumber(String number) {
		this.number = number;
	}

	public String getBlock() {
		return block;
	}

	public void setBlock(String block) {
		this.block = block;
	}

	public String getStair() {
		return stair;
	}

	public void setStair(String stair) {
		this.stair = stair;
	}

	public String getFloor() {
		return floor;
	}

	public void setFloor(String floor) {
		this.floor = floor;
	}

	public String getDoor() {
		return door;
	}

	public void setDoor(String door) {
		this.door = door;
	}

	public String getExtension() {
		return extension;
	}

	public void setExtension(String extension) {
		this.extension = extension;
	}

	public String getCountry() {
		return country;
	}

	public void setCountry(String country) {
		this.country = country;
	}

	public String getZip() {
		return zip;
	}

	public void setZip(String zip) {
		this.zip = zip;
	}

	public String getZone() {
		return zone;
	}

	public void setZone(String zone) {
		this.zone = zone;
	}

	public String getDisseminated_nucleus() {
		return disseminated_nucleus;
	}

	public void setDisseminated_nucleus(String disseminated_nucleus) {
		this.disseminated_nucleus = disseminated_nucleus;
	}

	public String getProvince() {
		return province;
	}

	public void setProvince(String province) {
		this.province = province;
	}

	public String getDelivery_point() {
		return delivery_point;
	}

	public void setDelivery_point(String delivery_point) {
		this.delivery_point = delivery_point;
	}

	public String getGeographical_point() {
		return geographical_point;
	}

	public void setGeographical_point(String geographical_point) {
		this.geographical_point = geographical_point;
	}

	public List<LinkModel> getLinks() {
		return links;
	}

	public void setLinks(List<LinkModel> links) {
		this.links = links;
	}

	public void addLink(LinkModel linkModel) {
		if (Objects.isNull(links)) {
			links = new ArrayList<>();
		}
		this.links.add(linkModel);
	}

}
