package main.gestiona.apirest.model;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ProfileDataPublicationModel {
	private static final Logger log = LoggerFactory.getLogger(ProfileDataPublicationModel.class);
	private int days_publish;
	private String days_publish_type;
	private String description;

	@Override
	public String toString() {
		final ObjectMapper objectMapper = new ObjectMapper();
		try {
			// Convertir el objeto a JSON
			return objectMapper.writeValueAsString(this);
		} catch (JsonProcessingException e) {
			log.error("Ha ocurrido un error al convertir el circuito de tramitación a JSON: {}", e.getMessage());
			return "{}"; // Si hay un error, devolver un JSON vacío
		}
	}

	public int getDays_publish() {
		return days_publish;
	}

	public void setDays_publish(int days_publish) {
		this.days_publish = days_publish;
	}

	public String getDays_publish_type() {
		return days_publish_type;
	}

	public void setDays_publish_type(String days_publish_type) {
		this.days_publish_type = days_publish_type;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}
}
