package main.gestiona.apirest.model;

import java.util.ArrayList;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class LinksModel {
	private List<LinkModel> links;

	public LinksModel() {

	}

	@Override
	public String toString() {
		final ObjectMapper objectMapper = new ObjectMapper();
		try {
			// Convertir el objeto a JSON
			return objectMapper.writeValueAsString(this);
		} catch (JsonProcessingException e) {
			return "{}"; // Si hay un error, devolver un JSON vacío
		}
	}

	public LinksModel(String rel, String href) {
		links = new ArrayList<>();
		links.add(new LinkModel(rel, href));
	}

	public List<LinkModel> getLinks() {
		return links;
	}

	public void setLinks(List<LinkModel> links) {
		this.links = links;
	}
}
