package main.gestiona.apirest.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class FileDocumentAnnotationModel {
	private String id;
	private String code;
	private List<LinkModel> links;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getCode() {
		return code;
	}

	public void setCode(String code) {
		this.code = code;
	}

	public List<LinkModel> getLinks() {
		return links;
	}

	public void setLinks(List<LinkModel> links) {
		this.links = links;
	}

	@Override
	public String toString() {
		final ObjectMapper objectMapper = new ObjectMapper();
		try {
			// Convertir el objeto a JSON
			return objectMapper.writeValueAsString(this);
		} catch (JsonProcessingException e) {
			return "{}"; // Si hay un error, devolver un JSON vacío
		}
	}
}
