package main.gestiona.apirest.model;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class DocumentModel {
	private String id;
	private String name;
	private String type;
	private String extension;
	private String file_name;
	private String file_name_with_extension;
	private String metadata_language;
	private List<LinkModel> links;

	public DocumentModel() {

	}

	public DocumentModel(List<LinkModel> links, String fileName) {
		this.links = links;
		this.type = "DIGITAL";
		this.metadata_language = "es";
		this.name = fileName;
	}

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getType() {
		return type;
	}

	public void setType(String type) {
		this.type = type;
	}

	public String getExtension() {
		return extension;
	}

	public void setExtension(String extension) {
		this.extension = extension;
	}

	public String getFile_name() {
		return file_name;
	}

	public void setFile_name(String file_name) {
		this.file_name = file_name;
	}

	public String getFile_name_with_extension() {
		return file_name_with_extension;
	}

	public void setFile_name_with_extension(String file_name_with_extension) {
		this.file_name_with_extension = file_name_with_extension;
	}

	public String getMetadata_language() {
		return metadata_language;
	}

	public void setMetadata_language(String metadata_language) {
		this.metadata_language = metadata_language;
	}

	public List<LinkModel> getLinks() {
		return links;
	}

	public void setLinks(List<LinkModel> links) {
		this.links = links;
	}
}
