package main.gestiona.apirest.model;

import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class CircuitTemplateModel {
	private static final Logger log = LoggerFactory.getLogger(CircuitTemplateModel.class);
	private String name;
	private boolean block_edit;
	private boolean restrict_use;
	private List<LinkModel> assigneds_can_use;
	private List<LinkModel> validators;
	private List<LinkModel> signers;
	private List<LinkModel> signer_representants;

	private String signature_order;
	private boolean sign_required;
	private boolean publish_in_board;
	private BoardDataPublicationModel board_data_publication;
	private boolean publish_in_profile;
	private BoardDataPublicationModel profile_data_publication;

	private boolean copy_to_book;
	private LinkModel book_to_send;
	private String book_year;
	private String book_extract;

	private String file_resolution;
	private boolean copy_to_files;
	private List<LinkModel> files_to_copy_document;
	private boolean send_registry_output;

	private List<ThirdOutputModel> thirds_ouput;
	private Delivery_Type send_registry_output_delivery_type;
	private Classification send_registry_output_classification;
	private String send_registry_output_description;
	private String send_registry_output_expiration_days;
	private TermTypeValue send_registry_output_expiration_days_term_type;
	private BOE_PUBLISH_AD_TYPE_VALUE send_registry_output_boe_publish_ad_type;
	private boolean send_registry_output_boe_publish_personal_data;
	private String send_registry_output_boe_publish_expiration_days;
	private TermTypeValue send_registry_output_boe_publish_expiration_days_term_type;
	private boolean send_registry_output_boe_publish_tax_notification;
	private BOE_MATTER_VALUE send_registry_output_boe_publish_matter;
	private String send_registry_output_boe_publish_signer;
	private PAPER_DELIVERY_MEDIA_VALUE send_registry_output_paper_delivery_media;

	private boolean archive_file;
	private ArchivedFileDataModel archived_file_data;
	private boolean send_alerts;
	private List<LinkModel> recipients;
	private String send_alerts_comment;

	private String version;
	private List<LinkModel> links;

	private boolean connectors;
	private List<ConnectorModel> connector_list;
	private boolean assign_file;
	private Assignation_Mode assign_file_mode;
	private String assign_file_reason;
	private List<LinkModel> assign_file_assigneds;

	private boolean change_file_state;
	private FILE_STATE_VALOR state_to_change_file;
	private BECAUSE_END_VALOR because_end;
	private String observations;
	private boolean send_to_collegiate_organ;
	private String send_to_collegiate_organ_title;
	private PROPOSAL_TYPE_VALUE send_to_collegiate_organ_proposal_type;
	private String send_to_collegiate_organ_proposal_text;
	private LinkModel collegiate_organ_to_send;

	@Override
	public String toString() {
		final ObjectMapper objectMapper = new ObjectMapper();
		try {
			// Convertir el objeto a JSON
			return objectMapper.writeValueAsString(this);
		} catch (JsonProcessingException e) {
			log.error("Ha ocurrido un error al convertir el circuito de tramitación a JSON: {}", e.getMessage());
			return "{}"; // Si hay un error, devolver un JSON vacío
		}
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public boolean isBlock_edit() {
		return block_edit;
	}

	public void setBlock_edit(boolean block_edit) {
		this.block_edit = block_edit;
	}

	public boolean isRestrict_use() {
		return restrict_use;
	}

	public void setRestrict_use(boolean restrict_use) {
		this.restrict_use = restrict_use;
	}

	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}

	public boolean isCopy_to_book() {
		return copy_to_book;
	}

	public void setCopy_to_book(boolean copy_to_book) {
		this.copy_to_book = copy_to_book;
	}

	public LinkModel getBook_to_send() {
		return book_to_send;
	}

	public void setBook_to_send(LinkModel book_to_send) {
		this.book_to_send = book_to_send;
	}

	public List<LinkModel> getValidators() {
		return validators;
	}

	public void setValidators(List<LinkModel> validators) {
		this.validators = validators;
	}

	public List<LinkModel> getSigners() {
		return signers;
	}

	public void setSigners(List<LinkModel> signers) {
		this.signers = signers;
	}

	public List<LinkModel> getLinks() {
		return links;
	}

	public void setLinks(List<LinkModel> links) {
		this.links = links;
	}

	public List<LinkModel> getAssigneds_can_use() {
		return assigneds_can_use;
	}

	public void setAssigneds_can_use(List<LinkModel> assigneds_can_use) {
		this.assigneds_can_use = assigneds_can_use;
	}

	public List<LinkModel> getSigner_representants() {
		return signer_representants;
	}

	public void setSigner_representants(List<LinkModel> signer_representants) {
		this.signer_representants = signer_representants;
	}

	public String getSignature_order() {
		return signature_order;
	}

	public void setSignature_order(String signature_order) {
		this.signature_order = signature_order;
	}

	public boolean isSign_required() {
		return sign_required;
	}

	public void setSign_required(boolean sign_required) {
		this.sign_required = sign_required;
	}

	public boolean isPublish_in_board() {
		return publish_in_board;
	}

	public void setPublish_in_board(boolean publish_in_board) {
		this.publish_in_board = publish_in_board;
	}

	public boolean isPublish_in_profile() {
		return publish_in_profile;
	}

	public void setPublish_in_profile(boolean publish_in_profile) {
		this.publish_in_profile = publish_in_profile;
	}

	public String getBook_year() {
		return book_year;
	}

	public void setBook_year(String book_year) {
		this.book_year = book_year;
	}

	public String getBook_extract() {
		return book_extract;
	}

	public void setBook_extract(String book_extract) {
		this.book_extract = book_extract;
	}

	public String getFile_resolution() {
		return file_resolution;
	}

	public void setFile_resolution(String file_resolution) {
		this.file_resolution = file_resolution;
	}

	public boolean isCopy_to_files() {
		return copy_to_files;
	}

	public void setCopy_to_files(boolean copy_to_files) {
		this.copy_to_files = copy_to_files;
	}

	public List<LinkModel> getFiles_to_copy_document() {
		return files_to_copy_document;
	}

	public void setFiles_to_copy_document(List<LinkModel> files_to_copy_document) {
		this.files_to_copy_document = files_to_copy_document;
	}

	public boolean isSend_registry_output() {
		return send_registry_output;
	}

	public void setSend_registry_output(boolean send_registry_output) {
		this.send_registry_output = send_registry_output;
	}

	public List<ThirdOutputModel> getThirds_ouput() {
		return thirds_ouput;
	}

	public void setThirds_ouput(List<ThirdOutputModel> thirds_ouput) {
		this.thirds_ouput = thirds_ouput;
	}

	public Delivery_Type getSend_registry_output_delivery_type() {
		return send_registry_output_delivery_type;
	}

	public void setSend_registry_output_delivery_type(Delivery_Type send_registry_output_delivery_type) {
		this.send_registry_output_delivery_type = send_registry_output_delivery_type;
	}

	public Classification getSend_registry_output_classification() {
		return send_registry_output_classification;
	}

	public void setSend_registry_output_classification(Classification send_registry_output_classification) {
		this.send_registry_output_classification = send_registry_output_classification;
	}

	public String getSend_registry_output_description() {
		return send_registry_output_description;
	}

	public void setSend_registry_output_description(String send_registry_output_description) {
		this.send_registry_output_description = send_registry_output_description;
	}

	public String getSend_registry_output_expiration_days() {
		return send_registry_output_expiration_days;
	}

	public void setSend_registry_output_expiration_days(String send_registry_output_expiration_days) {
		this.send_registry_output_expiration_days = send_registry_output_expiration_days;
	}

	public TermTypeValue getSend_registry_output_expiration_days_term_type() {
		return send_registry_output_expiration_days_term_type;
	}

	public void setSend_registry_output_expiration_days_term_type(TermTypeValue send_registry_output_expiration_days_term_type) {
		this.send_registry_output_expiration_days_term_type = send_registry_output_expiration_days_term_type;
	}

	public BOE_PUBLISH_AD_TYPE_VALUE getSend_registry_output_boe_publish_ad_type() {
		return send_registry_output_boe_publish_ad_type;
	}

	public void setSend_registry_output_boe_publish_ad_type(BOE_PUBLISH_AD_TYPE_VALUE send_registry_output_boe_publish_ad_type) {
		this.send_registry_output_boe_publish_ad_type = send_registry_output_boe_publish_ad_type;
	}

	public boolean isSend_registry_output_boe_publish_personal_data() {
		return send_registry_output_boe_publish_personal_data;
	}

	public void setSend_registry_output_boe_publish_personal_data(boolean send_registry_output_boe_publish_personal_data) {
		this.send_registry_output_boe_publish_personal_data = send_registry_output_boe_publish_personal_data;
	}

	public String getSend_registry_output_boe_publish_expiration_days() {
		return send_registry_output_boe_publish_expiration_days;
	}

	public void setSend_registry_output_boe_publish_expiration_days(String send_registry_output_boe_publish_expiration_days) {
		this.send_registry_output_boe_publish_expiration_days = send_registry_output_boe_publish_expiration_days;
	}

	public TermTypeValue getSend_registry_output_boe_publish_expiration_days_term_type() {
		return send_registry_output_boe_publish_expiration_days_term_type;
	}

	public void setSend_registry_output_boe_publish_expiration_days_term_type(TermTypeValue send_registry_output_boe_publish_expiration_days_term_type) {
		this.send_registry_output_boe_publish_expiration_days_term_type = send_registry_output_boe_publish_expiration_days_term_type;
	}

	public boolean isSend_registry_output_boe_publish_tax_notification() {
		return send_registry_output_boe_publish_tax_notification;
	}

	public void setSend_registry_output_boe_publish_tax_notification(boolean send_registry_output_boe_publish_tax_notification) {
		this.send_registry_output_boe_publish_tax_notification = send_registry_output_boe_publish_tax_notification;
	}

	public BOE_MATTER_VALUE getSend_registry_output_boe_publish_matter() {
		return send_registry_output_boe_publish_matter;
	}

	public void setSend_registry_output_boe_publish_matter(BOE_MATTER_VALUE send_registry_output_boe_publish_matter) {
		this.send_registry_output_boe_publish_matter = send_registry_output_boe_publish_matter;
	}

	public String getSend_registry_output_boe_publish_signer() {
		return send_registry_output_boe_publish_signer;
	}

	public void setSend_registry_output_boe_publish_signer(String send_registry_output_boe_publish_signer) {
		this.send_registry_output_boe_publish_signer = send_registry_output_boe_publish_signer;
	}

	public PAPER_DELIVERY_MEDIA_VALUE getSend_registry_output_paper_delivery_media() {
		return send_registry_output_paper_delivery_media;
	}

	public void setSend_registry_output_paper_delivery_media(PAPER_DELIVERY_MEDIA_VALUE send_registry_output_paper_delivery_media) {
		this.send_registry_output_paper_delivery_media = send_registry_output_paper_delivery_media;
	}

	public boolean isArchive_file() {
		return archive_file;
	}

	public void setArchive_file(boolean archive_file) {
		this.archive_file = archive_file;
	}

	public boolean isSend_alerts() {
		return send_alerts;
	}

	public void setSend_alerts(boolean send_alerts) {
		this.send_alerts = send_alerts;
	}

	public List<LinkModel> getRecipients() {
		return recipients;
	}

	public void setRecipients(List<LinkModel> recipients) {
		this.recipients = recipients;
	}

	public String getSend_alerts_comment() {
		return send_alerts_comment;
	}

	public void setSend_alerts_comment(String send_alerts_comment) {
		this.send_alerts_comment = send_alerts_comment;
	}

	public boolean isConnectors() {
		return connectors;
	}

	public void setConnectors(boolean connectors) {
		this.connectors = connectors;
	}

	public boolean isAssign_file() {
		return assign_file;
	}

	public void setAssign_file(boolean assign_file) {
		this.assign_file = assign_file;
	}

	public Assignation_Mode getAssign_file_mode() {
		return assign_file_mode;
	}

	public void setAssign_file_mode(Assignation_Mode assign_file_mode) {
		this.assign_file_mode = assign_file_mode;
	}

	public String getAssign_file_reason() {
		return assign_file_reason;
	}

	public void setAssign_file_reason(String assign_file_reason) {
		this.assign_file_reason = assign_file_reason;
	}

	public List<LinkModel> getAssign_file_assigneds() {
		return assign_file_assigneds;
	}

	public void setAssign_file_assigneds(List<LinkModel> assign_file_assigneds) {
		this.assign_file_assigneds = assign_file_assigneds;
	}

	public boolean isChange_file_state() {
		return change_file_state;
	}

	public void setChange_file_state(boolean change_file_state) {
		this.change_file_state = change_file_state;
	}

	public FILE_STATE_VALOR getState_to_change_file() {
		return state_to_change_file;
	}

	public void setState_to_change_file(FILE_STATE_VALOR state_to_change_file) {
		this.state_to_change_file = state_to_change_file;
	}

	public BECAUSE_END_VALOR getBecause_end() {
		return because_end;
	}

	public void setBecause_end(BECAUSE_END_VALOR because_end) {
		this.because_end = because_end;
	}

	public String getObservations() {
		return observations;
	}

	public void setObservations(String observations) {
		this.observations = observations;
	}

	public boolean isSend_to_collegiate_organ() {
		return send_to_collegiate_organ;
	}

	public void setSend_to_collegiate_organ(boolean send_to_collegiate_organ) {
		this.send_to_collegiate_organ = send_to_collegiate_organ;
	}

	public String getSend_to_collegiate_organ_title() {
		return send_to_collegiate_organ_title;
	}

	public void setSend_to_collegiate_organ_title(String send_to_collegiate_organ_title) {
		this.send_to_collegiate_organ_title = send_to_collegiate_organ_title;
	}

	public PROPOSAL_TYPE_VALUE getSend_to_collegiate_organ_proposal_type() {
		return send_to_collegiate_organ_proposal_type;
	}

	public void setSend_to_collegiate_organ_proposal_type(PROPOSAL_TYPE_VALUE send_to_collegiate_organ_proposal_type) {
		this.send_to_collegiate_organ_proposal_type = send_to_collegiate_organ_proposal_type;
	}

	public String getSend_to_collegiate_organ_proposal_text() {
		return send_to_collegiate_organ_proposal_text;
	}

	public void setSend_to_collegiate_organ_proposal_text(String send_to_collegiate_organ_proposal_text) {
		this.send_to_collegiate_organ_proposal_text = send_to_collegiate_organ_proposal_text;
	}

	public LinkModel getCollegiate_organ_to_send() {
		return collegiate_organ_to_send;
	}

	public void setCollegiate_organ_to_send(LinkModel collegiate_organ_to_send) {
		this.collegiate_organ_to_send = collegiate_organ_to_send;
	}

	public BoardDataPublicationModel getBoard_data_publication() {
		return board_data_publication;
	}

	public void setBoard_data_publication(BoardDataPublicationModel board_data_publication) {
		this.board_data_publication = board_data_publication;
	}

	public BoardDataPublicationModel getProfile_data_publication() {
		return profile_data_publication;
	}

	public void setProfile_data_publication(BoardDataPublicationModel profile_data_publication) {
		this.profile_data_publication = profile_data_publication;
	}

	public ArchivedFileDataModel getArchived_file_data() {
		return archived_file_data;
	}

	public void setArchived_file_data(ArchivedFileDataModel archived_file_data) {
		this.archived_file_data = archived_file_data;
	}

	public List<ConnectorModel> getConnector_list() {
		return connector_list;
	}

	public void setConnector_list(List<ConnectorModel> connector_list) {
		this.connector_list = connector_list;
	}

	public enum Classification {
		NOTIFICATION,        // Notificación
		COMUNICATION,        // Otro tipo de comunicación
		REGISTERED_LETTER,  // Carta certificada
		LETTER,            // Carta
	}

	public enum TermTypeValue {
		NATURAL_DAYS,    // Días naturales
		WORKING_DAYS    // Días hábiles
	}

	public enum BOE_PUBLISH_AD_TYPE_VALUE {
		PUBLICATION_IN_EXTRACT, // Publicación en extracto
		PUBLICATION_IN_FULL    // Publicación íntegra
	}

	public enum Delivery_Type {
		PRESENTIAL, //Presencial
		ORDINARY_MAIL, // Correo Postal (Ordinario)
		CERTIFIED_MAIL, // Correo Postal (Certificado)
		MESSENGER, // Mensajero
		TELEMATIC, // Telemática
		BUROFAX, // Burofax
		FAX, // Fax
		NOTARIAL, // Requerimiento Notarial
		OTHERS, // Otros
		EMAIL, // Correo electrónico
		ADMINISTRATIVE_MAIL, // Correo administrativo
		NOTIFICATOR, //Notificador
	}

	public enum Assignation_Mode {
		ADD, // Añade a las asignaciones existentes
		REPLACE, // Reemplaza la asignación existente
	}

	public enum FILE_STATE_VALOR {
		OPEN_EDITABLE,    // En instrucción
		OPEN_RESOLVED    // Finalizado
	}

	public enum PROPOSAL_TYPE_VALUE {
		FAVORABLE,    // Favorable
		UNFAVORABLE, // Desfavorable
		NONE, // No aplica
	}

	public enum BECAUSE_END_VALOR {
		ABANDONMENT_BY_ADMINISTRATION, // Desistimiento por la Administración
		WITHDRAWAL_AND_RESIGNATION_BY_STAKEHOLDERS, // Desistimiento y renuncia por los interesados
		EXPIRATION // Caducidad
	}

	public enum BOE_MATTER_VALUE {
		_1_AGRICULTURE_AND_LIVESTOCK,// 1 AGRICULTURA Y GANADERÍA
		_2_WATERS, // 2 AGUAS
		_3_CADASTRE, // 3 CATASTRO
		_4_HUNTING_AND_FISHING, // 4 CAZA Y PESCA
		_5_CONSUMPTION, // 5 CONSUMO
		_6_CREDIT_BANKING_AND_INSURANCE, // 6 CREDITO, BANCA Y SEGUROS
		_7_CULTURE_AND_SPECTACLES, // 7 CULTURA Y ESPECTACULOS
		_8_SPORTS, // 8 DEPORTES
		_9_ECONOMY_AND_TRADE, // 9 ECONOMIA Y COMERCIO
		_10_PUBLIC_EMPLOYEES, // 10 EMPLEADOS PUBLICOS
		_11_EMPLOYMENT, // 11 EMPLEO
		_12_ENERGY, // 12 ENERGIA
		_13_EDUCATION, // 13 EDUCACION
		_14_UNIVERSITY_EDUCATION, // 14 ENSEÑANZA UNIVERSITARIA
		_15_STATISTICS, // 15 ESTADISTICA
		_16_EXPROPRIATIONS, // 16 EXPROPIACIONES
		_17_FOREIGN_AFFAIRS, // 17 EXTRANJERÍA
		_18_ARMED_FORCES, // 18 FUERZAS ARMADAS
		_19_TREASURY, // 19 HACIENDA
		_20_INDUSTRY_AND_HANDICRAFT, // 20 INDUSTRIA Y ARTESANIA
		_21_INSPECTION_OF_WORK, // 21 INSPECCION DE TRABAJO
		_22_GAME, // 22 JUEGO
		_23_ENVIRONMENT_AND_SUSTAINABILITY, // 23 MEDIO AMBIENTE Y SOSTENIBILIDAD
		_24_METROLOGY, // 24 METROLOGIA
		_25_AIR_NAVIGATION, // 25 NAVEGACION AEREA
		_26_MARITIME_NAVIGATION_PORTS_AND_MARINE_MERCHANT, // 26 NAVEGACION MARITIMA, PUERTOS Y MARINA MERCANTE
		_27_NOTARY, // 27 NOTARIAS
		_28_URBANISM_AND_HOUSING, // 28 URBANISMO Y VIVIENDA
		_29_MUNICIPAL_REGISTER_OF_INHABITANTS, // 29 PADRON MUNICIPAL DE HABITANTES
		_30_HERITAGE_AND_PUBLIC_PROPERTIES, // 30 PATRIMONIO Y PROPIEDADES PUBLICAS
		_31_INTELLECTUAL_PROPERTY, // 31 PROPIEDAD INTELECTUAL
		_32_INDUSTRIAL_PROPERTY, // 32 PROPIEDAD INDUSTRIAL
		_33_PROTECTION_OF_PERSONAL_DATA, // 33 PROTECCION DE DATOS DE CARÁCTER PERSONAL
		_34_REGISTRIES_OF_PROPERTY, // 34 REGISTROS DE LA PROPIEDAD
		_35_SHAREHOLDERS_RESPONSIBILITY, // 35 RESPONSABILIDAD PATRIMONIAL
		_36_HEALTH_AND_PHARMACY, // 36 SANIDAD Y FARMACIA
		_37_CITIZEN_SECURITY_AND_CIVIL_PROTECTION, // 37 SEGURIDAD CIUDADANA Y PROTECCION CIVIL
		_38_BENEFITS_OF_SOCIAL_SECURITY_AND_MARITIME_SOCIAL_ACTION, // 38 PRESTACIONES DE SEGURIDAD SOCIAL Y DE ACCIÓN SOCIAL MARÍTIMA
		_39_FUNERAL_SERVICES, // 39 SERVICIOS FUNERARIOS
		_40_SOCIAL_SERVICES, // 40 SERVICIOS SOCIALES
		_41_SUBSIDIES_SCHOLARSHIPS_AND_OTHER_AID, // 41 SUBVENCIONES, BECAS Y OTRAS AYUDAS
		_42_TELECOMMUNICATIONS_AND_NEW_TECHNOLOGIES, // 42 TELECOMUNICACIONES Y NUEVAS TECNOLOGIAS
		_43_TRAFFIC_CIRCULATION_AND_ROAD_SAFETY, // 43 TRAFICO, CIRCULACION Y SEGURIDAD VIAL
		_44_TERRESTRIAL_TRANSPORTATION, // 44 TRANSPORTES TERRESTRES
		_45_TOURISM, //45 TURISMO
		_46_OTHER, // 46 OTRAS
		_47_REGISTRATION_AFFILIATION_AND_COLLECTION_OF_SOCIAL_SECURITY // 47 INSCRIPCIÓN, AFILIACIÓN Y RECAUDACIÓN DE LA SEGURIDAD SOCIAL
	}

	public enum PAPER_DELIVERY_MEDIA_VALUE {
		MANUAL, // Envío en papel manual
		CIE // Envío a través del Servicio de Impresión y Ensobrado
	}

}
