package main.gestiona.apirest.model;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

@JsonIgnoreProperties(ignoreUnknown = true)
@JsonInclude(JsonInclude.Include.NON_NULL)
public class ArchivedFileDataModel {
	private static final Logger log = LoggerFactory.getLogger(ArchivedFileDataModel.class);
	private String classification_code;
	private String press_mark;

	@Override
	public String toString() {
		final ObjectMapper objectMapper = new ObjectMapper();
		try {
			// Convertir el objeto a JSON
			return objectMapper.writeValueAsString(this);
		} catch (JsonProcessingException e) {
			log.error("Ha ocurrido un error al convertir el circuito de tramitación a JSON: {}", e.getMessage());
			return "{}"; // Si hay un error, devolver un JSON vacío
		}
	}

	public String getClassification_code() {
		return classification_code;
	}

	public void setClassification_code(String classification_code) {
		this.classification_code = classification_code;
	}

	public String getPress_mark() {
		return press_mark;
	}

	public void setPress_mark(String press_mark) {
		this.press_mark = press_mark;
	}
}
