package main.gestiona.apirest.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import jakarta.validation.constraints.NotBlank;

@Validated
@ConfigurationProperties(prefix = "mockup.gestiona.api.registries")
public class RegistriesConfig {

	@NotBlank(message = "The Gestiona API registry office code must have a value")
	private String registryOfficeCode = "RC";

	@NotBlank(message = "The Gestiona API registry category name must have a value")
	private String categoryName = "R005- INFRAESTRUCTURAS Y SERVICIOS";

	@NotBlank(message = "The Gestiona API registry subcategory name must have a value")
	private String subcategoryName = "Incidencias vía pública";

	public String getRegistryOfficeCode() {
		return registryOfficeCode;
	}

	public void setRegistryOfficeCode(String registryOfficeCode) {
		this.registryOfficeCode = registryOfficeCode;
	}

	public String getCategoryName() {
		return categoryName;
	}

	public void setCategoryName(String categoryName) {
		this.categoryName = categoryName;
	}

	public String getSubcategoryName() {
		return subcategoryName;
	}

	public void setSubcategoryName(String subCategoryName) {
		this.subcategoryName = subCategoryName;
	}
}
