package main.gestiona.apirest.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import jakarta.validation.constraints.NotBlank;

@Validated
@ConfigurationProperties(prefix = "mockup.gestiona.api.procedures")
public class ProceduresConfig {

	@NotBlank(message = "The Gestiona API procedure name must have a value")
	private String name = "Circulación e incidencias en la vía pública";

	@NotBlank(message = "The Gestiona API external procedure must have a value")
	private String externalProcedure = "Incidencias en vías públicas (integración)";

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getExternalProcedure() {
		return externalProcedure;
	}

	public void setExternalProcedure(String externalProcedure) {
		this.externalProcedure = externalProcedure;
	}
}
