package main.gestiona.apirest.config;

import org.hibernate.validator.constraints.URL;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import jakarta.validation.constraints.NotBlank;

@Validated
@ConfigurationProperties(prefix = "mockup.gestiona.api")
public class GestionaApiConfig {

	@URL
	@NotBlank(message = "The Gestiona API URL must be specified")
	private String url;

	@NotBlank(message = "The Gestiona API access token must be specified")
	private String accessToken;

	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	public String getAccessToken() {
		return accessToken;
	}

	public void setAccessToken(String accessToken) {
		this.accessToken = accessToken;
	}
}
