package main.connectors.thirds.view.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import jakarta.validation.constraints.NotBlank;
import main.config.validation.annotations.AbsolutePath;
import main.connectors.thirds.view.service.GoogleSheetsService.SearchType;

@Validated
@ConfigurationProperties(prefix = "mockup.connectors.third-data.google-sheets")
public class GoogleSheetsConfig {

	@NotBlank(message = "The spreadsheet ID must be specified")
	private String spreadsheetId;

	@AbsolutePath
	@NotBlank(message = "The credentials path must be specified")
	private String credentialsPath;

	private SearchType searchType = SearchType.INCIDENCE_GROUP;

	public String getSpreadsheetId() {
		return spreadsheetId;
	}

	public void setSpreadsheetId(String spreadsheetId) {
		this.spreadsheetId = spreadsheetId;
	}

	public String getCredentialsPath() {
		return credentialsPath;
	}

	public void setCredentialsPath(String credentialsPath) {
		this.credentialsPath = credentialsPath;
	}

	public SearchType getSearchType() {
		return searchType;
	}

	public void setSearchType(SearchType searchType) {
		this.searchType = searchType;
	}
}
