package main.connectors.common.service;

import org.springframework.stereotype.Service;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;

@Service
public class JwtService {

	/**
	 * Decodifica el token JWT y devuelve el objeto decodificado.
	 *
	 * @param token
	 * 		Token JWT a decodificar
	 *
	 * @return Objeto decodificado del token JWT
	 */
	public DecodedJWT decodeToken(String token) {
		return JWT.decode(token);
	}

	/**
	 * Obtiene el token de cliente del token JWT.
	 *
	 * @param jwt
	 * 		Token JWT
	 *
	 * @return el token de cliente
	 */
	public String getClientToken(DecodedJWT jwt) {
		return jwt.getClaim("client_token").asString();
	}

	/**
	 * Obtiene el recurso del token JWT.
	 *
	 * @param jwt
	 * 		Token JWT
	 *
	 * @return el recurso
	 */
	public String getResource(DecodedJWT jwt) {
		return jwt.getClaim("resource").asString();
	}

	/**
	 * Obtiene el identificador único (UUID) del token JWT.
	 *
	 * @param jwt
	 * 		Token JWT
	 *
	 * @return el UUID del token JWT
	 */
	public String getUuid(DecodedJWT jwt) {
		return jwt.getClaim("uuid").asString();
	}

	/**
	 * Obtiene el timestamp del token JWT.
	 *
	 * @param jwt
	 * 		Token JWT
	 *
	 * @return el timestamp del token JWT
	 */
	public Long getTimestamp(DecodedJWT jwt) {
		return jwt.getClaim("timestamp").asLong();
	}

	/**
	 * Obtiene la versión del token JWT.
	 *
	 * @param jwt
	 * 		Token JWT
	 *
	 * @return la versión del token JWT
	 */
	public String getVersion(DecodedJWT jwt) {
		return jwt.getClaim("version").asString();
	}

	/**
	 * Obtiene el identificador de transacción del token JWT.
	 *
	 * @param jwt
	 * 		Token JWT
	 *
	 * @return el identificador de transacción del token JWT
	 */
	public String getTransactionId(DecodedJWT jwt) {
		return jwt.getClaim("transaction_id").asString();
	}
}
