package main.connectors.common.service;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;

import org.springframework.stereotype.Service;

import main.connectors.common.model.FieldModel;

@Service
public class DataValidatorService {

	public static final String MSG_FIELD_UNEXPECTED_FORMAT = "FIELD_UNEXPECTED_FORMAT";
	private static final String MSG_FIELD_NOT_EXPECTED = "FIELD_NOT_EXPECTED";
	private static final String MSG_FIELD_EXPECTED = "FIELD_EXPECTED";
	private static final String STRING_TYPE = "STRING";

	/**
	 * Valida los parámetros de la petición comprobando que se encuentren aquellos indicados en `expectedFields`
	 *
	 * @param expectedFields
	 * 		campos esperados en los datos de la petición
	 * @param data
	 * 		datos de la petición
	 *
	 * @return mapa con los errores correspondientes, vacío si no hay errores
	 */
	public Map<String, String> checkDataParameters(Set<String> expectedFields, Map<String, FieldModel> data) {
		final Map<String, String> errors = new HashMap<>();

		for (String field : data.keySet()) {

			// Si encontramos un campo que no es esperado, marcamos el error
			if (!expectedFields.contains(field)) {
				errors.put(field, MSG_FIELD_NOT_EXPECTED);
			}

			// Si encontramos un campo esperado pero con un formato incorrecto, marcamos el error
			if (expectedFields.contains(field) && (!STRING_TYPE.equals(data.get(field).getType()) || data.get(field).getValue() == null)) {
				errors.put(field, MSG_FIELD_UNEXPECTED_FORMAT);
			}
		}

		for (String expectedField : expectedFields) {
			if (!data.containsKey(expectedField)) {
				errors.put(expectedField, MSG_FIELD_EXPECTED);
			}
		}

		return errors;
	}
}
