package main.config.validation.validators;

import java.nio.file.InvalidPathException;
import java.nio.file.Paths;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import main.config.validation.annotations.DatabaseUrl;

public class DatabaseUrlValidator implements ConstraintValidator<DatabaseUrl, String> {

	private static final String URL_PREFIX = "jdbc:h2:file:";

	@Override
	public boolean isValid(String url, ConstraintValidatorContext context) {
		if (url == null || !url.startsWith(URL_PREFIX)) {
			return false;
		}

		final String pathPart = url.substring(URL_PREFIX.length());

		try {
			Paths.get(pathPart);
			return true;

		} catch (InvalidPathException e) {
			return false;
		}
	}
}
