package main.config.validation.validators;

import java.nio.file.Paths;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import main.config.validation.annotations.AbsolutePath;

public class AbsolutePathValidator implements ConstraintValidator<AbsolutePath, String> {

	@Override
	public boolean isValid(String path, ConstraintValidatorContext context) {
		if (path == null || path.isEmpty()) {
			return true;
		}

		return Paths.get(path).isAbsolute();
	}
}
