package main.config.validation.annotations;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import jakarta.validation.Constraint;
import jakarta.validation.Payload;
import main.config.validation.validators.AbsolutePathValidator;

@Documented
@Constraint(validatedBy = AbsolutePathValidator.class)
@Target({ ElementType.METHOD, ElementType.FIELD })
@Retention(RetentionPolicy.RUNTIME)
public @interface AbsolutePath {

	String message() default "The String must be a valid absolute path";

	Class<?>[] groups() default {};

	Class<? extends Payload>[] payload() default {};
}
