package main.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import main.config.validation.annotations.AbsolutePath;

@Validated
@ConfigurationProperties(prefix = "mockup")
public class ServerConfig {

	@AbsolutePath
	private String fileUploadPath = "/tmp/uploads";

	public String getFileUploadPath() {
		return fileUploadPath;
	}

	public void setFileUploadPath(String fileUploadPath) {
		this.fileUploadPath = fileUploadPath;
	}
}
