package main.config;

import org.hibernate.validator.constraints.URL;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import jakarta.validation.constraints.NotBlank;

@Validated
@ConfigurationProperties(prefix = "mockup.github")
public class GithubProjectConfig {

	@URL
	@NotBlank(message = "The Github project URL must be specified")
	private String projectUrl;

	/**
	 * Getter del atributo que almacena la url del repositorio github
	 *
	 * @return la url del repositorio github a enseñar
	 */
	public String getProjectUrl() {
		return projectUrl;
	}

	public void setProjectUrl(String projectUrl) {
		this.projectUrl = projectUrl;
	}
}
