package main.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import jakarta.validation.constraints.NotBlank;
import main.config.validation.annotations.DatabaseUrl;

@Validated
@ConfigurationProperties(prefix = "mockup.database")
public class DatabaseConfig {

	@DatabaseUrl
	private String url;

	@NotBlank(message = "The username of the database source is required")
	private String username;

	@NotBlank(message = "The password of the database source is required")
	private String password;

	private Boolean populate = false;

	/**
	 * Getter del atributo que almacena la url de la base de datos
	 *
	 * @return la url de la base de datos
	 */
	public String getUrl() {
		return url;
	}

	public void setUrl(String url) {
		this.url = url;
	}

	/**
	 * Getter del atributo que almacena el nombre de usuario de la base de datos
	 *
	 * @return el nombre de usuario de la base de datos
	 */
	public String getUsername() {
		return username;
	}

	public void setUsername(String username) {
		this.username = username;
	}

	/**
	 * Getter del atributo que almacena la contraseña de la base de datos
	 *
	 * @return la contraseña de la base de datos
	 */
	public String getPassword() {
		return password;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	/**
	 * Getter del atributo que indica si se debe llenar la base de datos con datos de prueba
	 *
	 * @return true si se debe llenar la base de datos con datos de prueba, false en caso contrario
	 */
	public Boolean getPopulate() {
		return populate;
	}

	public void setPopulate(Boolean populate) {
		this.populate = populate;
	}
}
