package main.config;

import org.hibernate.validator.constraints.URL;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import jakarta.validation.constraints.NotBlank;

@Validated
@ConfigurationProperties(prefix = "mockup.data-set")
public class DataSetConfig {

	@URL
	@NotBlank(message = "The dataSet iframe URL must be specified")
	private String iframeUrl;

	/**
	 * Getter del atributo que almacena la url del iframe del DataSet
	 *
	 * @return la url del iframe a mostrar
	 */
	public String getIframeUrl() {
		return iframeUrl;
	}

	public void setIframeUrl(String iframeUrl) {
		this.iframeUrl = iframeUrl;
	}
}
