package main.config;

import org.hibernate.validator.constraints.URL;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

import jakarta.validation.constraints.NotBlank;

@Validated
@ConfigurationProperties(prefix = "mockup.academy")
public class AcademyConfig {

	@URL
	@NotBlank(message = "The academy iframe URL must not be null or empty")
	private String iframeUrl;

	/**
	 * Getter del atributo que almacena la url del iframe de la academia
	 *
	 * @return la url del iframe a mostrar
	 */
	public String getIframeUrl() {
		return iframeUrl;
	}

	public void setIframeUrl(String iframeUrl) {
		this.iframeUrl = iframeUrl;
	}
}
