# Mockup Gestiona for Developers

## Configuración

### Configuración general del servidor

`mockup.server.port`:
Puerto en el que se expondrá el servidor web de la aplicación.

_Default:_ 8080

`mockup.file-upload-path`:
Ruta local absoluta del directorio donde se guardarán los ficheros subidos
mediante la aplicación web.

_Default:_ `/tmp/uploads`

### Configuración de la base de datos

`mockup.database.url`:
URL de acceso al fichero de la base de datos H2. Debe estar formada por la ruta
absoluta o relativa, desde donde se lanza la aplicación, donde se quiera ubicar
la base de datos precedida por `jdbc:h2:file:` para indicar el conector a esta.
No es necesario que esté creada antes del arranque de la aplicación. Si este
fichero no existe, se creará automáticamente.

_Ejemplo:_

```properties
mockup.database.url = jdbc:h2:file:/ruta/baseDatos
```

`mockup.database.username`:
Nombre del usuario para conectar con la base de datos.

_Ejemplo:_ `root`

`mockup.databaser.password`:
Contraseña del usuario para poder conectar con la base de datos.

_Ejemplo:_ `password123`

`mockup.database.populate`:
Flag para indicar si se va a hacer el populate de la base de datos en el
arranque de la aplicación.

_Default:_ `false`

### Configuración de la sección Github

`mockup.github.project-url`:
URL al repositorio de Github a mostrar al seleccionar la pestaña `Github`
del menú de la aplicación web.

_Ejemplo:_ `https://github.com/miRepositorio`

### Configuración de la sección ApiDoc

`mockup.api-doc.iframe-url`:
URL a la ApiDoc a mostrar en un Iframe al seleccionar la pestaña `ApiDoc`
del menú de la aplicación web.
La página a la que referencia la URL debe poder ser embebida en un Iframe.

_Ejemplo:_ `https://g3stiona.com/rest/doc/`

### Configuración de la sección GesCode

`mockup.ges-code.iframe-url`:
URL a la página a mostrar en una pestaña nueva al seleccionar la pestaña
`GesCode` del menú de la aplicación web.

_Ejemplo:_ `https://url/ges-code`

### Configuración de la sección Academy

`mockup.academy.iframe-url`:
URL a la página de la Academy a mostrar en un Iframe al seleccionar la pestaña
`Academy` del menú de la aplicación web.
La página a la que referencia la URL debe poder ser embebida en un Iframe.

_Ejemplo:_ `https://url/academy`

### Configuración de la sección DataSet

`mockup.data-set.iframe-url`:
URL a la hoja de Google Sheets a mostrar en un Iframe al seleccionar la
pestaña `DataSet` del menú de la aplicación web.

_Ejemplo:_
`https://docs.google.com/spreadsheets/d/idHoja`

### Configuración de la API de Gestiona

`mockup.gestiona.api.url`:
URL a la máquina de Gestiona con la que se va a conectar la aplicación web.

_Ejemplo:_ https://numMaquina.g3stiona.com

`mockup.gestiona.api.access-token`:
Token de acceso del usuario empleando la aplicación para conectarse con la
máquina de Gestiona especificada en la property `mockup.gestiona.api.url`.

#### Configuración de los registros de entrada

`mockup.gestiona.api.registries.registry-office-code`:
Código de la oficina de registro en la que se van a crear los registros de
entrada en la aplicación. Este debe coincidir con el `code` de la oficina de
registro en Gestiona.

_Default:_ `RC`

`mockup.gestiona.api.registries.category-name`:
Nombre de la categoría en la que se van a crear los registros de entrada en
Gestiona al registrar nuevas incidencias. Este debe coincidir con el `name`
de la categoría en Gestiona.

_Default:_ `R005- INFRAESTRUCTURAS Y SERVICIOS`

`mockup.gestiona.api.registries.subcategory-name`:
Nombre de la subcategoría en la que se van a crear los registros de entrada
en Gestiona al registrar nuevas incidencias. Este debe coincidir con el
`name` de la categoría en Gestiona y debe ser una subcategoría de la
categoría indicada en la property.
`mockup.gestiona.api.registries.category-name`.

_Default:_ `Incidencias vía pública`

### Configuración de los procedimientos para el registro de incidencias

`mockup.gestiona.api.procedure.external-procedure`:
Título del trámite externo con el que se van a crear los expedientes en
Gestiona al registrar nuevas incidencias. Este debe coincidir con el `title`
del trámite externo en Gestiona. Este debe ser del nuevo catálogo.

_Default:_ `Incidencias en vías públicas (integración)`

`mockup.gestiona.api.procedures.name`:
Nombre del procedimiento al que pertenece el trámite externo en Gestiona.
Este debe coincidir con el `name` del procedimiento al que pertenece el
trámite externo indicado en la property
`mockup.gestiona.api.procedures.external-procedure`. Este debe ser del nuevo
catálogo.

_Default:_ `Circulación e incidencias en la vía pública`

### Configuración de los conectores

#### Configuración de los clientes de los conectores

`mockup.connectors.clients.list`:
Lista de clientes registrados en la aplicación.
Por cada uno de estos clientes se han de especificar las siguientes properties:

`mockup.connectors.clients.cliente1.id`:
Identificador único del cliente con nombre `cliente1`. Este debe coincidir
con el `client_token` del token JWT `X-Rest-Basic-Token` enviado en las
peticiones a los conectores.
Es proporcionado por Espublico.

`mockup.connectors.clients.cliente1.public-key`:
Clave pública para el algoritmo `HMAC-SHA256` del cliente con nombre
`cliente1`.
Es proporcionada por Espublico.

_Ejemplo:_

```properties
mockup.connectors.clients.list                = cliente1, cliente2

mockup.connectors.clients.cliente1.id         = idCliente1
mockup.connectors.clients.cliente1.public-key = clavePublicaCliente1

mockup.connectors.clients.cliente2.id         = idCliente2
mockup.connectors.clients.cliente2.public-key = clavePublicaCliente2
```

#### Configuración del conector de datos de terceros

`mockup.connectors.third-data.google-sheets.credentials-path`:
Ruta local absoluta al fichero JSON que contiene las credenciales para la
conexión a la API de Google Sheets.

_Ejemplo:_ `/ruta/credentials.json`

`mockup.connectors.third-data.google-sheets.spreadsheet-id`:
Identificador único de la hoja de Google Sheets con los datos de los terceros.

`mockup.connectors.third-data.google-sheets.search-type`:
Tipo de dato para la búsqueda del tercero en el conector de datos de
tercero. Tiene 3 posibles valores: `INCIDENCE_GROUP`, `INCIDENCE_NUMBER` y `NIF`

_Default:_ `INCIDENCE_GROUP`