using Microsoft.EntityFrameworkCore;
using mockup_gestiona_for_developers_net.Data;
using mockup_gestiona_for_developers_net.Exception;
using mockup_gestiona_for_developers_net.Models;

namespace mockup_gestiona_for_developers_net.Repository;

public class IncidenceRepository(ApplicationDbContext context)
    : IIncidenceRepository
{
    public async Task<List<IncidenceModel>> GetAllIncidencesAsync()
    {
        return await context.Incidences.ToListAsync();
    }

    public async Task AddIncidenceAsync(IncidenceModel incidence)
    {
        await context.Incidences.AddAsync(incidence);
        await context.SaveChangesAsync();
    }

    public async Task UpdateIncidenceAsync(IncidenceModel incidence)
    {
        var existingIncidence =
            await context.Incidences.FindAsync(incidence.Id);
        if (existingIncidence == null)
        {
            throw new IncidenceNotFoundException(
                $"No se ha encontrado la incidencia con id {incidence.Id}");
        }

        context.Incidences.Update(incidence);
        await context.SaveChangesAsync();
    }

    public async Task<IncidenceModel?> GetIncidenceByNumFile(string numFile)
    {
        return await context.Incidences.FirstOrDefaultAsync(incidence =>
            incidence.GestionaFileNumber != null &&
            incidence.GestionaFileNumber == numFile);
    }

    public async Task<IncidenceModel?> GetIncidenceByNumber(string number)
    {
        return await context.Incidences.FirstOrDefaultAsync(incidence =>
            incidence.IncidenceNumber! == number);
    }

    public async Task SaveAsync(IncidenceModel incidence)
    {
        await context.SaveChangesAsync();
    }
}