using Microsoft.EntityFrameworkCore;
using mockup_gestiona_for_developers_net.Data;
using mockup_gestiona_for_developers_net.Exception;
using mockup_gestiona_for_developers_net.Models;

namespace mockup_gestiona_for_developers_net.Repository;

public class DocumentaryFlowRepository(ApplicationDbContext context) : IDocumentaryFlowRepository
{
    public async Task<List<DocumentaryFlowModel>> GetAllDocumentaryFlowsAsync()
    {
        return await context.DocumentaryFlows.ToListAsync();
    }

    public async Task AddDocumentaryFlowAsync(DocumentaryFlowModel flow)
    {
        await context.DocumentaryFlows.AddAsync(flow);
        await context.SaveChangesAsync();
    }

    public async Task UpdateDocumentaryFlowAsync(DocumentaryFlowModel flow)
    {
        var existingFlow = await context.DocumentaryFlows.FindAsync(flow.Id);
        if (existingFlow == null)
        {
            throw new DocumentaryFlowNotFoundException($"No se ha encontrado el flujo documental con id {flow.Id}");
        }

        context.DocumentaryFlows.Update(flow);
        await context.SaveChangesAsync();
    }

    public async Task<DocumentaryFlowModel> FindById(string id)
    {
        return await context.DocumentaryFlows.FindAsync(id) ??
               throw new DocumentaryFlowNotFoundException("No se ha encontrado el flujo documental con id {id}");
    }

    public async Task<DocumentaryFlowModel?> FindByFileIdGestiona(string fileIdGestiona)
    {
        return await context.DocumentaryFlows.FirstOrDefaultAsync(df => df.FileIdGestiona == fileIdGestiona);
    }
}