# Mockup Gestiona for Developers

## Configuración del servidor

El servidor se configura en el fichero `launchSettings.json` que se
encuentra dentro de la carpeta `Properties`. En este tenemos los diferentes
perfiles con sus configuraciones por defecto, pero en el caso de que se
desease cambiar la dirección del servidor o el puerto en el que se lance se
deberá hacer a través del `applicationUrl` de los perfiles.

_Ejemplo:_ `http{s}://dirección-servidor:puerto-servidor`

## Configuración del proyecto

La configuración se lleva a cabo a través del fichero `appsettings.json` y
`appsettings.Development.json` en caso de desarrollo. Si el entorno se ha
establecido como desarrollo, las propiedades de configuración del
`appsettings.Development.json` sobreescribirán las definidas en el
`appsettings.json`.

Cada una de las propiedades mostradas a continuación estás estructuradas
bajo la clave `MockupSettings` dentro de la clave `AppSettings`.

### Configuración del almacenamiento de ficheros en el servidor

Cada una de las propiedades mostradas a continuación estás estructuradas
bajo la clave `UploadsSettings`.

`FileUploadPath`:
Ruta local absoluta del directorio donde se guardarán los ficheros subidos
mediante la aplicación web.

_Default:_ `/tmp/uploads`

### Configuración de la base de datos

Cada una de las propiedades mostradas a continuación estás estructuradas
bajo la clave `DatabaseSettings`.

`Url`:
URL de acceso al fichero de la base de datos SQLLite. Debe estar formada por
la ruta absoluta o relativa, desde donde se lanza la aplicación, donde se
quiera ubicar la base de datos. La extensión del fichero de la base de datos
debe ser `.db`. Si este fichero no existe se creará automáticamente.

_Ejemplo:_ `/ruta/miBaseDeDatos.db`

Una vez declarada es necesario crear una nueva migración ejecutando este
comando desde la terminal, ubicado en la raíz del proyecto:

```shell
dotnet ef migrations add NombreDeLaMigracion
```

Siendo `NombreDeLaMigracion` el nombre que se le quiera asignar. Una vez
creada, para aplicar la migración a la base de datos se tiene que ejecutar
el siguiente comando:

```shell
dotnet ef database update
```

Será necesario crear una nueva migración con cada cambio en el esquema de la
base de datos o en el caso de que se borre y posteriormente aplicarla.

`Populate`:
Flag para indicar si se va a hacer el populate de la base de datos en el
arranque de la aplicación.

_Default:_ `false`

### Configuración de la sección Github

Cada una de las propiedades mostradas a continuación estás estructuradas
bajo la clave `GithubSettings`.

`ProjectUrl`:
URL al repositorio de Github a mostrar al seleccionar la pestaña `Github`
del menú de la aplicación web.

_Ejemplo:_ `https://github.com/miRepositorio`

### Configuración de la sección ApiDoc

Cada una de las propiedades mostradas a continuación estás estructuradas
bajo la clave `ApiDocSettings`.

`IframeUrl`:
URL a la ApiDoc a mostrar en un Iframe al seleccionar la pestaña `ApiDoc`
del menú de la aplicación web.
La página a la que referencia la URL debe poder ser embebida en un Iframe.

_Ejemplo:_ `https://g3stiona.com/rest/doc/`

### Configuración de la sección GesCode

Cada una de las propiedades mostradas a continuación estás estructuradas
bajo la clave `GesCodeSettings`.

`IframeUrl`:
URL a la página a mostrar en una pestaña nueva al seleccionar la pestaña
`GesCode` del menú de la aplicación web.

_Ejemplo:_ `https://url/ges-code`

### Configuración de la sección Academy

Cada una de las propiedades mostradas a continuación estás estructuradas
bajo la clave `AcademySettings`.

`IframeUrl`:
URL a la página de la Academy a mostrar en un Iframe al seleccionar la pestaña
`Academy` del menú de la aplicación web.
La página a la que referencia la URL debe poder ser embebida en un Iframe.

_Ejemplo:_ `https://url/academy`

### Configuración de la sección DataSet

Cada una de las propiedades mostradas a continuación estás estructuradas
bajo la clave `DataSetSettings`.

`IframeUrl`:
URL a la hoja de Google Sheets a mostrar en un Iframe al seleccionar la
pestaña `DataSet` del menú de la aplicación web.

_Ejemplo:_
`https://docs.google.com/spreadsheets/d/idHoja`

### Configuración de la API de Gestiona

Cada una de las propiedades mostradas a continuación estás estructuradas
bajo la clave `GestionaApiSettings`.

`Url`:
URL a la máquina de Gestiona con la que se va a conectar la aplicación web.

_Ejemplo:_ https://numMaquina.g3stiona.com

`AccessToken`:
Token de acceso del usuario empleando la aplicación para conectarse con la
máquina de Gestiona especificada en la property `mockup.gestiona.api.url`.

#### Configuración de los registros de entrada

Cada una de las propiedades mostradas a continuación estás estructuradas
bajo la clave `RegistriesSettings` dentro de la clave `GestionaApiSettings`.

`RegistryOfficeCode`:
Código de la oficina de registro en la que se van a crear los registros de
entrada en la aplicación. Este debe coincidir con el `code` de la oficina de
registro en Gestiona.

_Default:_ `RC`

`CategoryName`:
Nombre de la categoría en la que se van a crear los registros de entrada en
Gestiona al registrar nuevas incidencias. Este debe coincidir con el `name`
de la categoría en Gestiona.

_Default:_ `R005- INFRAESTRUCTURAS Y SERVICIOS`

`SubcategoryName`:
Nombre de la subcategoría en la que se van a crear los registros de entrada
en Gestiona al registrar nuevas incidencias. Este debe coincidir con el
`name` de la categoría en Gestiona y debe ser una subcategoría de la
categoría indicada en la property.
`mockup.gestiona.api.registries.category-name`.

_Default:_ `Incidencias vía pública`

#### Configuración de los procedimientos

Cada una de las propiedades mostradas a continuación estás estructuradas
bajo la clave `ProcedureSettings` dentro de la clave `GestionaApiSettings`.

`ExternalProcedureName`:
Título del trámite externo con el que se van a crear los expedientes en
Gestiona al registrar nuevas incidencias. Este debe coincidir con el `title`
del trámite externo en Gestiona. Este debe ser del nuevo catálogo.

_Default:_ `Incidencias en vías públicas (integración)`

`ProcedureName`:
Nombre del procedimiento al que pertenece el trámite externo en Gestiona.
Este debe coincidir con el `name` del procedimiento al que pertenece el
trámite externo indicado en la property
`mockup.gestiona.api.procedures.external-procedure`. Este debe ser del nuevo
catálogo.

_Default:_ `Circulación e incidencias en la vía pública`

### Configuración de los conectores

Cada una de las propiedades mostradas a continuación están estructuradas
bajo la clave `ConnectorsSettings`.

#### Configuración de los clientes de los conectores

`Clients`:
Diccionario que define el conjunto de clientes con sus claves privadas
asociadas. Cada par clave-valor representa:

- **Key:** Identificador único del cliente. Este debe coincidir
  con el `client_token` del token JWT `X-Rest-Basic-Token` enviado en las
  peticiones a los conectores. Es proporcionado por Espublico.
- **Value:** Clave pública para el algoritmo `HMAC-SHA256` del cliente. Es
  proporcionada por Espublico.

_Ejemplo:_

```json
{
    "Clients": {
        "idCliente1": "clavePublicaCliente1",
        "idCliente2": "clavePublicaCliente2"
    }
}
```

#### Configuración del conector de datos de terceros

##### Configuración de Google Sheets

Cada una de las propiedades mostradas a continuación estás estructuradas
bajo la clave `GoogleSheetsSettings` dentro de la clave `ThirdDataSettings`.

`CredentialsPath`:
Ruta local absoluta al fichero JSON que contiene las credenciales para la
conexión a la API de Google Sheets.

_Ejemplo:_ `/ruta/credentials.json`

`SpreadsheetId`:
Identificador único de la hoja de Google Sheets con los datos de los terceros.

`SearchType`:
Tipo de dato para la búsqueda del tercero en el conector de datos de
tercero. Tiene 3 posibles valores: `INCIDENCE_GROUP`, `INCIDENCE_NUMBER` y `NIF`

_Default:_ `INCIDENCE_GROUP`