using Microsoft.EntityFrameworkCore;
using Microsoft.Extensions.Options;
using mockup_gestiona_for_developers_net.Components;
using mockup_gestiona_for_developers_net.Configuration;
using mockup_gestiona_for_developers_net.Connectors.Comm.Service;
using mockup_gestiona_for_developers_net.Connectors.ThirdData.Services;
using mockup_gestiona_for_developers_net.Data;
using mockup_gestiona_for_developers_net.Gestiona.ApiRest;
using mockup_gestiona_for_developers_net.Gestiona.ApiRest.Services;
using mockup_gestiona_for_developers_net.Repository;
using mockup_gestiona_for_developers_net.Service;

var builder = WebApplication.CreateBuilder(args);

builder.Services.AddRazorComponents()
    .AddInteractiveServerComponents();

builder.Services.AddOptions<MockupSettings>().BindConfiguration("AppSettings:MockupSettings").ValidateDataAnnotations().ValidateOnStart();
builder.Services.AddOptions<GithubSettings>().BindConfiguration("AppSettings:MockupSettings:GithubSettings").ValidateDataAnnotations().ValidateOnStart();
builder.Services.AddOptions<UploadsSettings>().BindConfiguration("AppSettings:MockupSettings:UploadsSettings").ValidateDataAnnotations().ValidateOnStart();
builder.Services.AddOptions<DatabaseSettings>().BindConfiguration("AppSettings:MockupSettings:DatabaseSettings").ValidateDataAnnotations().ValidateOnStart();
builder.Services.AddOptions<GesCodeSettings>().BindConfiguration("AppSettings:MockupSettings:GesCodeSettings").ValidateDataAnnotations().ValidateOnStart();
builder.Services.AddOptions<ApiDocSettings>().BindConfiguration("AppSettings:MockupSettings:ApiDocSettings").ValidateDataAnnotations().ValidateOnStart();
builder.Services.AddOptions<DataSetSettings>().BindConfiguration("AppSettings:MockupSettings:DataSetSettings").ValidateDataAnnotations().ValidateOnStart();
builder.Services.AddOptions<AcademySettings>().BindConfiguration("AppSettings:MockupSettings:AcademySettings").ValidateDataAnnotations().ValidateOnStart();
builder.Services.AddOptions<GestionaApiSettings>().BindConfiguration("AppSettings:MockupSettings:GestionaApiSettings").ValidateDataAnnotations()
    .ValidateOnStart();
builder.Services.AddOptions<RegistriesSettings>().BindConfiguration("AppSettings:MockupSettings:GestionaApiSettings:RegistriesSettings")
    .ValidateDataAnnotations()
    .ValidateOnStart();
builder.Services.AddOptions<ConnectorsSettings>().BindConfiguration("AppSettings:MockupSettings:ConnectorsSettings").ValidateDataAnnotations()
    .ValidateOnStart();
builder.Services.AddOptions<ThirdDataSettings>().BindConfiguration("AppSettings:MockupSettings:ConnectorsSettings:ThirdDataSettings").ValidateDataAnnotations()
    .ValidateOnStart();
builder.Services.AddOptions<GoogleSheetsSettings>().BindConfiguration("AppSettings:MockupSettings:ConnectorsSettings:ThirdDataSettings:GoogleSheetsSettings")
    .ValidateDataAnnotations().ValidateOnStart();

builder.Services.AddSingleton(sp => sp.GetRequiredService<IOptions<MockupSettings>>().Value);

builder.Services.AddControllers();

builder.Services.AddHostedService<StartupService>();
builder.Services.AddSingleton<IHttpContextAccessor, HttpContextAccessor>();
builder.Services.AddSingleton<JwtService>();
builder.Services.AddSingleton<SignatureService>();
builder.Services.AddSingleton<ConnectorUtilsService>();

builder.Services.AddSingleton<DataValidatorService>();
builder.Services.AddSingleton<GoogleSheetsService>();
builder.Services.AddSingleton<GestionaApiUtilsService>();
builder.Services.AddSingleton<GestionaApiService>();
builder.Services.AddSingleton<FileService>();
builder.Services.AddSingleton<RegistryService>();
builder.Services.AddSingleton<DocumentService>();
builder.Services.AddSingleton<UploadService>();
builder.Services.AddSingleton<ProcedureService>();
builder.Services.AddSingleton<ThirdService>();

builder.Services.AddScoped<IIncidenceRepository, IncidenceRepository>();
builder.Services.AddScoped<IncidenceService>();

builder.Services.AddScoped<IDocumentaryFlowRepository, DocumentaryFlowRepository>();
builder.Services.AddScoped<DocumentaryFlowService>();

var databasePath = builder.Configuration["AppSettings:MockupSettings:DatabaseSettings:Url"];

builder.Services.AddDbContext<ApplicationDbContext>(options =>
    options.UseSqlite($"Data Source={databasePath}"));

var app = builder.Build();

// Invocación al método SeedData del ApplicationDbContext
using (var scope = app.Services.CreateScope())
{
    var dbContext = scope.ServiceProvider.GetRequiredService<ApplicationDbContext>();
    dbContext.SeedData(); // Llamada al método SeedData
}

// Configure the HTTP request pipeline.
if (!app.Environment.IsDevelopment())
{
    app.UseExceptionHandler("/Error", createScopeForErrors: true);
    // The default HSTS value is 30 days. You may want to change this for production scenarios, see https://aka.ms/aspnetcore-hsts.
    app.UseHsts();
}

app.MapControllers();

app.UseHttpsRedirection();

app.UseStaticFiles();
app.UseAntiforgery();

app.MapRazorComponents<App>()
    .AddInteractiveServerRenderMode();

app.Run();