using System.ComponentModel.DataAnnotations;

namespace mockup_gestiona_for_developers_net.Models;

using System.Globalization;

public class IncidenceModel
{
    [Key] public string? Id { get; set; }
    public string? IncidenceNumber { get; set; }
    public string? Dni { get; set; }
    public string? Subject { get; set; }
    public string? GestionaRegistryNumber { get; set; }
    public string? GestionaFileNumber { get; set; }
    public int? Priority { get; set; }
    public IncidenceStatus Status { get; set; }

    public IncidenceModel()
    {
    }

    public IncidenceModel(string? incidenceNumber, string? dni, string? subject, string? gestionaRegistryNumber, string? gestionaFileNumber,
        int priority, IncidenceStatus status)
    {
        Id = Guid.NewGuid().ToString();
        IncidenceNumber = incidenceNumber;
        Dni = dni;
        Subject = subject;
        GestionaRegistryNumber = gestionaRegistryNumber;
        GestionaFileNumber = gestionaFileNumber;
        Priority = priority;
        Status = status;
    }

    public IncidenceModel(string? dni, string? subject, string? gestionaRegistryNumber, string? gestionaFileNumber, IncidenceStatus status)
    {
        Id = Guid.NewGuid().ToString();
        IncidenceNumber = GenerateTimestamp();
        Dni = dni;
        Subject = subject;
        GestionaRegistryNumber = gestionaRegistryNumber;
        GestionaFileNumber = gestionaFileNumber;
        Status = status;
    }

    private static string GenerateTimestamp()
    {
        return DateTime.Now.ToString("yyyyMMddHHmmss", CultureInfo.InvariantCulture);
    }

    public enum IncidenceStatus
    {
        [Display(Name = "Resuelta")] RESOLVED,
        [Display(Name = "Asignada")] ASSIGNED,
        [Display(Name = "Sin asignar")] UNASSIGNED
    }
}