using System.ComponentModel.DataAnnotations;

namespace mockup_gestiona_for_developers_net.Models;

public class DocumentaryFlowModel
{
    [Key] public string Id { get; init; }
    public string? FileIdGestiona { get; set; }
    public string? FileCodeGestiona { get; set; }
    public string? DocumentCsv { get; set; }
    public string? RegistryIdGestiona { get; set; }
    public string? RegistryCodeGestiona { get; set; }
    public string? Dni { get; set; }
    public Status State { get; set; }
    public string? NotificationState { get; set; }
    public string? DocumentReference { get; set; }

    public DocumentaryFlowModel()
    {
        Id = Guid.NewGuid().ToString();
    }

    public DocumentaryFlowModel(string? fileCodeGestiona, string? fileIdGestiona)
    {
        Id = Guid.NewGuid().ToString();
        FileCodeGestiona = fileCodeGestiona;
        FileIdGestiona = fileIdGestiona;
        State = Status.PENDING;
    }

    public DocumentaryFlowModel(string? fileIdGestiona, string? fileCodeGestiona, string? documentCsv, string? registryIdGestiona, string? registryCodeGestiona,
        string? dni, Status state, string? notificationState)
    {
        Id = Guid.NewGuid().ToString();
        FileIdGestiona = fileIdGestiona;
        FileCodeGestiona = fileCodeGestiona;
        DocumentCsv = documentCsv;
        RegistryIdGestiona = registryIdGestiona;
        RegistryCodeGestiona = registryCodeGestiona;
        Dni = dni;
        State = state;
        NotificationState = notificationState;
    }

    public enum Status
    {
        [Display(Name = "Pendiente")] PENDING,
        [Display(Name = "Subido")] UPLOADED,
        [Display(Name = "En tramitación")] IN_PROCESS,
        [Display(Name = "Cancelado")] CANCELED,
        [Display(Name = "Rechazado")] REVOKED,
        [Display(Name = "Fallido")] FAILED,
        [Display(Name = "Error desconocido")] UNKNOWN_ERROR,
        [Display(Name = "Terminado con errores")] FINISHED_WITH_ERRORS,
        [Display(Name = "Tramitado")] FINISHED
    }
}