using mockup_gestiona_for_developers_net.Gestiona.ApiRest.Exceptions;
using mockup_gestiona_for_developers_net.Gestiona.ApiRest.Models;

namespace mockup_gestiona_for_developers_net.Gestiona.ApiRest.Services;

using Exception = System.Exception;

public class FileService(GestionaApiUtilsService gestionaApiUtilsService)
{
    private const string GESTIONA_FILES_REL = "vnd.gestiona.files";
    private const string FILE_OPEN_REL = "file-open";
    private const string MEDIA_TYPE_FILE_OPENING = "application/vnd.gestiona.file-opening+json;version=1";

    /// <summary>
    /// Obtiene el listado de expedientes de Gestiona
    /// </summary>
    /// <returns>El listado de expedientes</returns>
    /// <exception cref="GestionaApiException">En caso de que no haya podido sacar el listado de expedientes</exception>
    public async Task<List<FileModel>> GetFileList()
    {
        var url = gestionaApiUtilsService.GetBookmarkUrl(GESTIONA_FILES_REL);

        var response = await gestionaApiUtilsService
            .CreatePetitionAsync<FilePageModel>(url, HttpMethod.Get, null, null);

        return response.Body?.Content
               ?? throw new GestionaApiException("No se ha podido obtener el listado de expedientes");
    }

    /// <summary>
    /// Abre un expediente a partir de sus datos de apertura
    /// </summary>
    /// <param name="fileOpeningModel">Datos de apertura de un expediente</param>
    /// <returns>Los datos del expediente abierto</returns>
    /// <exception cref="GestionaApiException">En caso de que no pueda abrir el expediente</exception>
    public async Task<FileModel> OpenFile(FileOpeningModel fileOpeningModel)
    {
        try
        {
            var url = GestionaApiUtilsService.ObtainLinkByRel(fileOpeningModel.Links!, FILE_OPEN_REL);

            var extraHeaders = new Dictionary<string, string> { { GestionaApiUtilsService.CONTENT_TYPE, MEDIA_TYPE_FILE_OPENING } };

            var response = await gestionaApiUtilsService.CreatePetitionAsync<FileModel>(url, HttpMethod.Post, extraHeaders, fileOpeningModel);

            return response.Body!;
        }
        catch (Exception e)
        {
            throw new GestionaApiException($"Error abriendo el expediente: {e}");
        }
    }
}