namespace mockup_gestiona_for_developers_net.Gestiona.ApiRest.Models;

using System.Text.Json.Serialization;

public class ThirdPartyModel
{
    [JsonPropertyName("id")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Id { get; set; }

    [JsonPropertyName("name")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Name { get; set; }

    [JsonPropertyName("first_name")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? FirstName { get; set; }

    [JsonPropertyName("first_surname")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? FirstSurname { get; set; }

    [JsonPropertyName("second_surname")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? SecondSurname { get; set; }

    [JsonPropertyName("nif")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Nif { get; set; }

    [JsonPropertyName("notification_channel")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public GestionaApiUtilsService.NotificationChannelType? NotificationChannel { get; set; }

    [JsonPropertyName("relation")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public ThirdOutputModel.RelationType? Relation { get; set; }

    [JsonPropertyName("type")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Type { get; set; }

    [JsonPropertyName("version")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Version { get; set; }

    [JsonPropertyName("links")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public List<LinkModel>? Links { get; set; }

    // Default constructor
    public ThirdPartyModel()
    {
        Links = [];
    }

    // Constructor that takes ThirdModel
    public ThirdPartyModel(ThirdModel thirdModel)
    {
        FirstName = thirdModel.FirstName;
        FirstSurname = thirdModel.FirstSurname;
        Nif = thirdModel.Nif;
        NotificationChannel = thirdModel.NotificationChannel;
        Relation = ThirdOutputModel.RelationType.INVOLVED;
        Type = thirdModel.Type;
        Links = new List<LinkModel>();
    }
}