namespace mockup_gestiona_for_developers_net.Gestiona.ApiRest.Models;

using System.Text.Json.Serialization;

public class ThirdOutputModel
{
    [JsonPropertyName("notification_channel")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingDefault)]
    public GestionaApiUtilsService.NotificationChannelType? NotificationChannel { get; set; }

    [JsonPropertyName("email")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Email { get; set; }

    [JsonPropertyName("relation")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public RelationType? Relation { get; set; }

    [JsonPropertyName("allowed_access")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingDefault)]
    public bool AllowedAccess { get; set; }

    [JsonPropertyName("type_of_road")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? TypeOfRoad { get; set; }

    [JsonPropertyName("address")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Address { get; set; }

    [JsonPropertyName("number")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Number { get; set; }

    [JsonPropertyName("block")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Block { get; set; }

    [JsonPropertyName("stair")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Stair { get; set; }

    [JsonPropertyName("floor")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Floor { get; set; }

    [JsonPropertyName("door")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Door { get; set; }

    [JsonPropertyName("extension")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Extension { get; set; }

    [JsonPropertyName("country")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Country { get; set; }

    [JsonPropertyName("zip")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Zip { get; set; }

    [JsonPropertyName("zone")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Zone { get; set; }

    [JsonPropertyName("disseminated_nucleus")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? DisseminatedNucleus { get; set; }

    [JsonPropertyName("province")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Province { get; set; }

    [JsonPropertyName("delivery_point")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? DeliveryPoint { get; set; }

    [JsonPropertyName("geographical_point")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? GeographicalPoint { get; set; }

    [JsonPropertyName("links")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public List<LinkModel>? Links { get; set; }

    public void AddLink(LinkModel linkModel)
    {
        if (Links == null)
            Links = new List<LinkModel>();

        Links.Add(linkModel);
    }

    [JsonConverter(typeof(JsonStringEnumConverter))]
    public enum RelationType
    {
        [JsonPropertyName("INVOLVED")] INVOLVED,
        [JsonPropertyName("REPRESENTANT")] REPRESENTANT,
        [JsonPropertyName("SOLICITOR")] SOLICITOR,
        [JsonPropertyName("COMPLAINANT")] COMPLAINANT,
        [JsonPropertyName("DENOUNCED")] DENOUNCED,
        [JsonPropertyName("TENDERER")] TENDERER,
        [JsonPropertyName("OWNER")] OWNER,
        [JsonPropertyName("TRANSFERER")] TRANSFERER,
        [JsonPropertyName("AQUIRER")] AQUIRER,
        [JsonPropertyName("RECIPIENT")] RECIPIENT,
        [JsonPropertyName("APPLICANT")] APPLICANT,
        [JsonPropertyName("PROVIDER")] PROVIDER,
        [JsonPropertyName("REGISTRY")] REGISTRY,
        [JsonPropertyName("CONTRACTING")] CONTRACTING,
        [JsonPropertyName("ANY_SOLICITOR")] ANY_SOLICITOR,
        [JsonPropertyName("SUPPLIER")] SUPPLIER
    }
}