using System.Text.Json.Serialization;

namespace mockup_gestiona_for_developers_net.Gestiona.ApiRest.Models;

public class RegistryAnnotationModel
{
    [JsonPropertyName("id")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Id { get; set; }

    [JsonPropertyName("code")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Code { get; set; }

    [JsonPropertyName("summary")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Summary { get; set; }

    [JsonPropertyName("category")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Category { get; set; }

    [JsonPropertyName("subcategory")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Subcategory { get; set; }

    [JsonPropertyName("links")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public List<LinkModel>? Links { get; set; }

    public RegistryAnnotationModel() { }

    public RegistryAnnotationModel(string subject, string registryCategory, string registrySubcategory)
    {
        Summary = subject ?? throw new ArgumentNullException(nameof(subject));
        Category = registryCategory ?? throw new ArgumentNullException(nameof(registryCategory));
        Subcategory = registrySubcategory ?? throw new ArgumentNullException(nameof(registrySubcategory));
    }
}