using System.ComponentModel.DataAnnotations.Schema;
using System.Text.Json.Serialization;

namespace mockup_gestiona_for_developers_net.Gestiona.ApiRest.Models;

[ComplexType]
public class LinkModel
{
    [JsonPropertyName("rel")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Rel { get; set; }

    [JsonPropertyName("href")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Href { get; set; }

    [JsonPropertyName("title")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Title { get; set; }

    public LinkModel() {}

    public LinkModel(string rel, string href, string? title = null)
    {
        Rel = rel;
        Href = href;
        Title = title;
    }

    public override string ToString()
    {
        return $"{{\"rel\": \"{Rel}\", \"href\": \"{Href}\", \"title\": \"{Title}\"}}";
    }
}