namespace mockup_gestiona_for_developers_net.Gestiona.ApiRest.Models;

using System.Text.Json.Serialization;

public class DocumentProcessStateModel
{
    [JsonPropertyName("state")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingDefault)]
    public DocumentProcessState State { get; set; }

    [JsonPropertyName("init_by")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public LinkModel? InitBy { get; set; }

    [JsonPropertyName("init_date")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? InitDate { get; set; }

    [JsonPropertyName("links")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public List<LinkModel>? Links { get; set; }

    [JsonConverter(typeof(JsonStringEnumConverter))]
    public enum DocumentProcessState
    {
        [JsonPropertyName("IN_PROGRESS")] IN_PROGRESS,
        [JsonPropertyName("CANCELED")] CANCELED,
        [JsonPropertyName("REVOKED")] REVOKED,
        [JsonPropertyName("FAILED")] FAILED,
        [JsonPropertyName("FINISHED")] FINISHED,

        [JsonPropertyName("FINISHED_WITH_ERRORS")]
        FINISHED_WITH_ERRORS
    }
}