namespace mockup_gestiona_for_developers_net.Gestiona.ApiRest.Models;

using System.Text.Json;
using System.Text.Json.Serialization;

public class DocumentModel
{
    [JsonPropertyName("id")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Id { get; set; }

    [JsonPropertyName("name")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Name { get; set; }

    [JsonPropertyName("type")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Type { get; set; }

    [JsonPropertyName("extension")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Extension { get; set; }

    [JsonPropertyName("file_name")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? FileName { get; set; }
    
    [JsonPropertyName("file_name_with_extension")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? FileNameWithExtension { get; set; }

    [JsonPropertyName("metadata_language")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? MetadataLanguage { get; set; }

    [JsonPropertyName("links")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public List<LinkModel>? Links { get; set; }

    public DocumentModel() { }

    public DocumentModel(List<LinkModel>? links, string fileName)
    {
        Links = links;
        Name = fileName;
        Type = "DIGITAL";
        MetadataLanguage = "es";
    }
}