namespace mockup_gestiona_for_developers_net.Gestiona.ApiRest.Models;

using System.Text.Json;
using System.Text.Json.Serialization;
using Exception = System.Exception;

public class CircuitTemplateModel
{
    [JsonPropertyName("name")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Name { get; set; }

    [JsonPropertyName("block_edit")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingDefault)]
    public bool? BlockEdit { get; set; }

    [JsonPropertyName("assigneds_can_use")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public List<LinkModel>? AssignedsCanUse { get; set; }

    [JsonPropertyName("validators")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public List<LinkModel>? Validators { get; set; }

    [JsonPropertyName("signers")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public List<LinkModel>? Signers { get; set; }

    [JsonPropertyName("signer_representants")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public List<LinkModel>? SignerRepresentants { get; set; }

    [JsonPropertyName("signature_order")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? SignatureOrder { get; set; }

    [JsonPropertyName("sign_required")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingDefault)]
    public bool? SignRequired { get; set; }

    [JsonPropertyName("publish_in_board")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingDefault)]
    public bool? PublishInBoard { get; set; }

    [JsonPropertyName("publish_in_profile")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingDefault)]
    public bool? PublishInProfile { get; set; }

    [JsonPropertyName("profile_data_publication")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? ProfileDataPublication { get; set; }

    [JsonPropertyName("copy_to_book")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingDefault)]
    public bool? CopyToBook { get; set; }

    [JsonPropertyName("book_to_send")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public LinkModel? BookToSend { get; set; }

    [JsonPropertyName("book_year")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? BookYear { get; set; }

    [JsonPropertyName("book_extract")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? BookExtract { get; set; }

    [JsonPropertyName("file_resolution")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? FileResolution { get; set; }

    [JsonPropertyName("copy_to_files")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingDefault)]
    public bool? CopyToFiles { get; set; }

    [JsonPropertyName("files_to_copy_document")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public List<LinkModel>? FilesToCopyDocument { get; set; }

    [JsonPropertyName("send_registry_output")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingDefault)]
    public bool SendRegistryOutput { get; set; }

    [JsonPropertyName("thirds_ouput")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingDefault)]
    public List<ThirdOutputModel>? ThirdsOutput { get; set; }

    [JsonPropertyName("send_registry_output_delivery_type")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? SendRegistryOutputDeliveryType { get; set; }

    [JsonPropertyName("send_registry_output_classification")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? SendRegistryOutputClassification { get; set; }

    [JsonPropertyName("send_registry_output_description")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? SendRegistryOutputDescription { get; set; }

    [JsonPropertyName("send_registry_output_expiration_days")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingDefault)]
    public int SendRegistryOutputExpirationDays { get; set; }

    [JsonPropertyName("send_registry_output_expiration_days_term_type")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? SendRegistryOutputExpirationDaysTermType { get; set; }

    [JsonPropertyName("send_registry_output_boe_publish_ad_type")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? SendRegistryOutputBoePublishAdType { get; set; }

    [JsonPropertyName("send_registry_output_boe_publish_personal_data")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingDefault)]
    public bool? SendRegistryOutputBoePublishPersonalData { get; set; }

    [JsonPropertyName("send_registry_output_boe_publish_expiration_days")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingDefault)]
    public int SendRegistryOutputBoePublishExpirationDays { get; set; }

    [JsonPropertyName("send_registry_output_boe_publish_expiration_days_term_type")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? SendRegistryOutputBoePublishExpirationDaysTermType { get; set; }

    [JsonPropertyName("send_registry_output_boe_publish_tax_notification")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingDefault)]
    public bool? SendRegistryOutputBoePublishTaxNotification { get; set; }

    [JsonPropertyName("send_registry_output_boe_publish_matter")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? SendRegistryOutputBoePublishMatter { get; set; }

    [JsonPropertyName("send_registry_output_boe_publish_signer")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? SendRegistryOutputBoePublishSigner { get; set; }

    [JsonPropertyName("send_registry_output_paper_delivery_media")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? SendRegistryOutputPaperDeliveryMedia { get; set; }

    [JsonPropertyName("archive_file")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingDefault)]
    public bool? ArchiveFile { get; set; }

    [JsonPropertyName("send_alerts")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingDefault)]
    public bool? SendAlerts { get; set; }

    [JsonPropertyName("recipients")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public List<LinkModel>? Recipients { get; set; }

    [JsonPropertyName("send_alerts_comment")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? SendAlertsComment { get; set; }

    [JsonPropertyName("version")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? Version { get; set; }

    [JsonPropertyName("links")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public List<LinkModel>? Links { get; set; }

    [JsonPropertyName("connectors")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingDefault)]
    public bool? Connectors { get; set; }

    [JsonPropertyName("assign_file")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingDefault)]
    public bool? AssignFile { get; set; }

    [JsonPropertyName("assign_file_mode")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? AssignFileMode { get; set; }

    [JsonPropertyName("assign_file_reason")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public string? AssignFileReason { get; set; }

    [JsonPropertyName("assign_file_assigneds")]
    [JsonIgnore(Condition = JsonIgnoreCondition.WhenWritingNull)]
    public List<LinkModel>? AssignFileAssigneds { get; set; }

    public override string ToString()
    {
        try
        {
            return JsonSerializer.Serialize(this);
        }
        catch (Exception e)
        {
            Console.Error.WriteLine($"Error al convertir el circuito a JSON: {e.Message}");
            return "{}";
        }
    }

    public enum Classification
    {
        NOTIFICATION, // Notificación
        COMUNICATION, // Otro tipo de comunicación
        REGISTERED_LETTER, // Carta certificada
        LETTER, // Carta
    }
}