using Microsoft.EntityFrameworkCore;
using mockup_gestiona_for_developers_net.Models;

namespace mockup_gestiona_for_developers_net.Data;

using Configuration;
using Microsoft.Extensions.Options;

public class ApplicationDbContext(
    DbContextOptions<ApplicationDbContext> options,
    MockupSettings mockupSettings) : DbContext(options)
{
    public DbSet<DocumentaryFlowModel> DocumentaryFlows { get; set; }

    public DbSet<IncidenceModel> Incidences { get; set; }

    public void SeedData()
    {
        var loadSampleData = mockupSettings.DatabaseSettings.Populate;

        if (!loadSampleData) return;

        LoadDocumentaryFlows();
        LoadIncidences();
        SaveChanges();
    }

    private void LoadDocumentaryFlows()
    {
        DocumentaryFlows.AddRange(
            new DocumentaryFlowModel("File1", "Code1", "Doc1.csv", "Reg1",
                "RegCode1", "DNI1", DocumentaryFlowModel.Status.PENDING,
                "Notification1"),
            new DocumentaryFlowModel("File2", "Code2", "Doc2.csv", "Reg2",
                "RegCode2", "DNI2", DocumentaryFlowModel.Status.IN_PROCESS,
                "Notification2"),
            new DocumentaryFlowModel("File3", "Code3", "Doc3.csv", "Reg3",
                "RegCode3", "DNI3", DocumentaryFlowModel.Status.FINISHED,
                "Notification3"),
            new DocumentaryFlowModel("File4", "Code4", "Doc4.csv", "Reg4",
                "RegCode4", "DNI4", DocumentaryFlowModel.Status.PENDING,
                "Notification4"),
            new DocumentaryFlowModel("File5", "Code5", "Doc5.csv", "Reg5",
                "RegCode5", "DNI5", DocumentaryFlowModel.Status.IN_PROCESS,
                "Notification5")
        );
    }

    private void LoadIncidences()
    {
        Incidences.AddRange(
            new IncidenceModel("1", "DNI1", "Subject1", "Reg1", "RegCode1",
                9, IncidenceModel.IncidenceStatus.UNASSIGNED),
            new IncidenceModel("2", "DNI2", "Subject2", "Reg2", "RegCode2",
                2, IncidenceModel.IncidenceStatus.ASSIGNED),
            new IncidenceModel("3", "DNI3", "Subject3", "Reg3", "RegCode3",
                9, IncidenceModel.IncidenceStatus.RESOLVED),
            new IncidenceModel("4", "DNI4", "Subject4", "Reg4", "RegCode4",
                5, IncidenceModel.IncidenceStatus.ASSIGNED),
            new IncidenceModel("5", "DNI5", "Subject5", "Reg5", "RegCode5",
                2, IncidenceModel.IncidenceStatus.UNASSIGNED),
            new IncidenceModel("6", "DNI6", "Subject6", "Reg6", "RegCode6",
                9, IncidenceModel.IncidenceStatus.RESOLVED)
        );
    }
}