using System.IdentityModel.Tokens.Jwt;

namespace mockup_gestiona_for_developers_net.Connectors.Comm.Service;

public class JwtService
{
    /// <summary>
    /// Decodifica el token JWT para poder leer sus campos
    /// </summary>
    /// <param name="token">Token JWT</param>
    /// <returns>El diccionario con los campos del token JWT</returns>
    public IDictionary<string, object> DecodeJwtToken(string token)
    {
        var jwtHandler = new JwtSecurityTokenHandler();
        var jsonToken = jwtHandler.ReadJwtToken(token); // Esto decodifica el token JWT
        return jsonToken.Payload;
    }
}