using mockup_gestiona_for_developers_net.Connectors.Common.Models;

namespace mockup_gestiona_for_developers_net.Connectors.Comm.Service;

public class DataValidatorService
{
    public const string MSG_FIELD_UNEXPECTED_FORMAT = "FIELD_UNEXPECTED_FORMAT";
    private const string MSG_FIELD_NOT_EXPECTED = "FIELD_NOT_EXPECTED";
    private const string MSG_FIELD_EXPECTED = "FIELD_EXPECTED";

    /// <summary>
    /// Valida los parámetros de la petición comprobando que se encuentren aquellos indicados en `expectedFields`.
    /// </summary>
    /// <param name="expectedFields">Campos esperados en los datos de la petición.</param>
    /// <param name="data">Datos de la petición.</param>
    /// <returns>Mapa con los errores correspondientes, vacío si no hay errores.</returns>
    public static Dictionary<string, string> CheckDataParameters(HashSet<string> expectedFields, Dictionary<string, FieldModel> data)
    {
        var errors = new Dictionary<string, string>();

        // Validar campos no esperados o con formato incorrecto
        foreach (var field in data.Keys)
        {
            // Campo no esperado
            if (!expectedFields.Contains(field))
            {
                errors.Add(field, MSG_FIELD_NOT_EXPECTED);
            }

            // Campo con formato incorrecto
            if (expectedFields.Contains(field) &&
                (!"STRING".Equals(data[field].Type, StringComparison.OrdinalIgnoreCase) || string.IsNullOrEmpty(data[field].Value)))
            {
                errors.Add(field, MSG_FIELD_UNEXPECTED_FORMAT);
            }
        }

        // Validar campos esperados ausentes
        foreach (var expectedField in expectedFields.Where(expectedField => !data.ContainsKey(expectedField)))
        {
            errors.Add(expectedField, MSG_FIELD_EXPECTED);
        }

        return errors;
    }
}