namespace mockup_gestiona_for_developers_net.Configuration.Validation;

using System.ComponentModel.DataAnnotations;

public class ValidPathAttribute : ValidationAttribute
{
    protected override ValidationResult? IsValid(object? value, ValidationContext validationContext)
    {
        if (value is string path && !string.IsNullOrWhiteSpace(path))
        {
            if (path.IndexOfAny(Path.GetInvalidPathChars()) >= 0)
            {
                return new ValidationResult($"The path '{path}' contains invalid characters.");
            }

            if (Path.IsPathRooted(path) || !Path.IsPathFullyQualified(path))
            {
                return ValidationResult.Success;
            }

            return new ValidationResult($"The path '{path}' is not valid.");
        }

        return new ValidationResult("Path is required and cannot be null or empty.");
    }
}