namespace mockup_gestiona_for_developers_net.Configuration;

using System.ComponentModel.DataAnnotations;

public class GestionaApiSettings
{
    [Required(ErrorMessage = "La URL de la API de Gestiona es obligatoria")]
    [Url(ErrorMessage = "La URL de la API de Gestiona no tiene un formato válido")]
    public string? Url { get; set; }

    [Required(ErrorMessage = "El token de acceso a la API de Gestiona es obligatorio")]
    public string? AccessToken { get; set; }

    public RegistriesSettings RegistriesSettings { get; set; } = new();

    public ProcedureSettings ProcedureSettings { get; set; } = new();

}

public class RegistriesSettings
{

    public string RegistryOfficeCode { get; set; } = "RC";

    public string CategoryName { get; set; } = "R005- INFRAESTRUCTURAS Y SERVICIOS";

    public string SubcategoryName { get; set; } = "Incidencias vía pública";
}

public class ProcedureSettings
{
    public string ProcedureName { get; set; } = "Circulación e incidencias en la vía pública";

    public string ExternalProcedureName { get; set; } = "Incidencias en vías públicas (integración)";
}