namespace mockup_gestiona_for_developers_net.Configuration;

using System.ComponentModel.DataAnnotations;
using Connectors.ThirdData.Services;
using Validation;

public class ConnectorsSettings
{

    [Required(ErrorMessage = "El mapa con los clientes es obligatorio")]
    public IDictionary<string, string>? Clients { get; set; }

    [Required] public ThirdDataSettings ThirdDataSettings { get; set; } = null!;
}

public class ThirdDataSettings
{
    [Required] public GoogleSheetsSettings GoogleSheetsSettings { get; set; } = null!;

}

public class GoogleSheetsSettings
{
    [Required(ErrorMessage = "La ruta al fichero JSON con las credenciales de Google Sheets es obligatoria")]
    [ValidPath(ErrorMessage = "La ruta al fichero JSON con las credenciales de Google Sheets no tiene un formato válido")]
    public string? CredentialsPath { get; set; }

    [Required(ErrorMessage = "El id de la hoja de cálculo en Google Sheets es obligatoria")]
    public string? SpreadsheetId { get; set; }

    public GoogleSheetsService.SearchType? SearchType { get; set; } = GoogleSheetsService.SearchType.INCIDENCE_GROUP;
}