package tech.espublico.pades.server.signers.sign.timestamp;

import java.util.Objects;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import tech.espublico.pades.server.models.TimestamperData;
import tech.espublico.pades.server.signers.sign.timestamp.TimestamperException.TimestamperExceptionReason;

public class TimestamperHelper {

	private static final Logger logger = LoggerFactory.getLogger(TimestamperHelper.class);

	public static byte[] getRespBytesFromTimestamper(TimestamperService timestamperService, String digestAlg, final byte[] hash, final TimestamperData timestamperData,
			final TimestamperData backupTimestamperData) throws TimestamperException {
		Objects.requireNonNull(hash, "hash");
		Objects.requireNonNull(timestamperData, "timestamperData");

		byte[] respBytes;
		try {
			respBytes = timestamperService.getTSResponse(digestAlg, hash, timestamperData.getServer(), timestamperData.getUser(),
					timestamperData.getPassword());
		} catch (TimestamperException | RuntimeException e) {
			logger.error(String.format("Fail connecting timestamper server %s.", timestamperData), e);

			//If we don't have a backup timestamp server configured or is not enable we cannot procede
			if (backupTimestamperData == null || !backupTimestamperData.isEnabled())
				throw new TimestamperException("could not get storage timestamp due to TimestamperException", null,
						TimestamperExceptionReason.BACKUP_NO_CONFIGURE, e);
			else {
				logger.info("Trying with backup timestamper server {}", backupTimestamperData);
				respBytes = timestamperService.getTSResponse(digestAlg, hash, backupTimestamperData.getServer(), backupTimestamperData.getUser(),
						backupTimestamperData.getPassword());
			}
		}
		return respBytes;
	}

}
